::*********************************************************
:: MED Batch file used for manual installs or testing 
::
:: This file will help guide new installs as well
:: as testing instances. This is responsible for
:: creating new registries as well as setting up
:: the test/production DLL and registries related
:: to CPRS. This will also provide setup services
:: for patch related test.
::
::*********************************************************



::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::: Start of file, Change ProdLoc or TestLoc Only  ::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::
setlocal enabledelayedexpansion

set ProdLoc=C:\Program Files (x86)\Vista\Mobile Electronic Documentation
set TestLoc=C:\MEDGUITest

ECHO OFF
cls
Goto 508Ask
::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::: Test Patch specific Code  ::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:PatchMenu
CLS
ECHO.
ECHO   _____      _       _       __  __                  
ECHO  ^|  __ \    ^| ^|     ^| ^|     ^|  \/  ^|                 
ECHO  ^| ^|__) ^|_ _^| ^|_ ___^| ^|__   ^| \  / ^| ___ _ __  _   _ 
ECHO  ^|  ___/ _` ^| __/ __^| '_ \  ^| ^|\/^| ^|/ _ \ '_ \^| ^| ^| ^|
ECHO  ^| ^|  ^| (_^| ^| ^|^| (__^| ^| ^| ^| ^| ^|  ^| ^|  __/ ^| ^| ^| ^|_^| ^|
ECHO  ^|_^|   \__,_^|\__\___^|_^| ^|_^| ^|_^|  ^|_^|\___^|_^| ^|_^|\__,_^|
ECHO ===============================================================                          
ECHO.          
ECHO.
:: Add your patch number to this menu. make sure you have a call for it
ECHO 1 - Patch 315
ECHO 2 - Test Menu
ECHO.
SET /P M=Type 1 or 2 then press ENTER:
IF %M%==1 GOTO 315Menu
IF %M%==2 GOTO TESTMENU
           

::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::: Add your methods here ::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:315Menu
CLS
ECHO.
ECHO   _______ _____ _    _    _   ____  __ _____ 
ECHO  ^|__   __^|_   _^| ^|  ^| ^|/\^| ^|/\___ \/_ ^| ____^|
ECHO     ^| ^|    ^| ^| ^| ^|  ^| ^|\ ` ' / __) ^|^| ^| ^|__  
ECHO     ^| ^|    ^| ^| ^| ^|  ^| ^|_     _^|__ ^< ^| ^|___ \ 
ECHO     ^| ^|   _^| ^|_^| ^|__^| ^|/ , . \___) ^|^| ^|___) ^|
ECHO     ^|_^|  ^|_____^|\____/ \/^|_^|\/____/ ^|_^|____/                                                   
ECHO ===============================================================    
ECHO. 
ECHO **************************** NOTE *****************************
ECHO  This setup will move the current production database over to 
ECHO  the test folder. This is needed to test the issue with   
ECHO  importing user notes via CPRS and the Import DLL.                                   
ECHO *************************************************************** 
ECHO.
ECHO.
ECHO 1 - Continue with setup
ECHO 2 - Patch Menu
ECHO.
SET /P M=Type 1 or 2 then press ENTER:
IF %M%==1 GOTO 315EXEC
IF %M%==2 GOTO PatchMenu

:315EXEC
CLS
ECHO. 
Echo Select the user id that will be running this test

:: Need to collect the user we are trying to run for
call :UserSelect

CLS
ECHO.
ECHO   _______ _____ _    _    _   ____  __ _____ 
ECHO  ^|__   __^|_   _^| ^|  ^| ^|/\^| ^|/\___ \/_ ^| ____^|
ECHO     ^| ^|    ^| ^| ^| ^|  ^| ^|\ ` ' / __) ^|^| ^| ^|__  
ECHO     ^| ^|    ^| ^| ^| ^|  ^| ^|_     _^|__ ^< ^| ^|___ \ 
ECHO     ^| ^|   _^| ^|_^| ^|__^| ^|/ , . \___) ^|^| ^|___) ^|
ECHO     ^|_^|  ^|_____^|\____/ \/^|_^|\/____/ ^|_^|____/                                                   
ECHO ===============================================================    
ECHO.
ECHO.

Set DBFileLoc=!ProfileIs!\AppData\Local\Mobile Electronic Documentation\db

If Exist "%DBFileLoc%\MED.mdb" ( 
	for /f "tokens=1-4 delims=/ " %%i in ("%date%") do (Set datestr=%%j%%k%%l)
    For /f "tokens=1-3 delims=/:" %%i in ("%time%") do (set timestr=%%i%%j%%k)
	Echo Backing up database associated with 315
	echo Backing up "%DBFileLoc%\MED.mdb" to MED_!datestr!!timestr!.mdb
	ECHO.
	ren "%DBFileLoc%\MED.mdb" "MED_!datestr!!timestr!.mdb"  
	IF %ERRORLEVEL% NEQ 0 (
		CALL :ERRORDSP "Error renaming AppData database"
		GOTO MENU
	)
	rem Echo Deleting database associated with 315
	rem del "!ProfileIs!\AppData\Local\Mobile Electronic Documentation\db\MED.mdb
)

ECHO Copying %ProdLoc%\db\MED.mdb to %TestLoc%\db\MED.mdb
ECHO.
Copy "%ProdLoc%\db\MED.mdb" "%TestLoc%\db\MED.mdb"
IF %ERRORLEVEL% NEQ 0 (
	CALL :ERRORDSP "Error copying production database to test"
	GOTO MENU
)

ECHO Complete
pause
call :315Menu

:UserSelect
CLS
ECHO.
ECHO   _____            __ _ _           
ECHO  ^|  __ \          / _(_) ^|          
ECHO  ^| ^|__) ^| __ ___ ^| ^|_ _^| ^| ___  ___ 
ECHO  ^|  ___/ '__/ _ \^|  _^| ^| ^|/ _ \/ __^|
ECHO  ^| ^|   ^| ^| ^| (_) ^| ^| ^| ^| ^|  __/\__ \
ECHO  ^|_^|   ^|_^|  \___/^|_^| ^|_^|_^|\___^|^|___/                                                                          
ECHO ===============================================================                          
ECHO. 
ECHO **************************** NOTE *****************************
ECHO  The database in the user's AppData will be renamed for backup 
ECHO  reasons. This way when patch TIU*1.0*315 is ran a fresh copy
ECHO  will be brought over.                                   
ECHO *************************************************************** 
ECHO.          
set "SourceDir=C:\Users"
Echo 0 - Exit
FOR /d %%i IN ("%SourceDir%\*") DO (
 set /A #+=1
 FOR /f "delims=." %%j IN ("%%i") DO (
	echo !#! - %%~nj
	set "option[!#!]=%%i"
 )
)
set SourceDir=
set /P "SelectProfile=Please choose the user profile who is testing or 0 to exit then press ENTER:"
IF %SelectProfile%==0 call :PatchMenu
if not defined option[%SelectProfile%] (
 echo Invalid selection, please try again
 call :UserSelect
) else (
 set "ProfileIs=!option[%SelectProfile%]!"
 exit /b
)
::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::: Standard Med code, do not change  :::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:508Ask
CLS
ECHO.
ECHO 508 Check
ECHO.
ECHO Are you running a screen reader? 
ECHO.          
ECHO.
ECHO 1 - No
ECHO 2 - Yes
ECHO 3 - EXIT
ECHO.
SET /P M=Type 1, 2, or 3 then press ENTER:
IF %M%==2 (
	CALL MEDBatch508.bat
	exit
)
IF %M%==1 GOTO MENU
IF %M%==3 GOTO Quit

:MENU
CLS
ECHO.                                                                                 
ECHO   __  __   ______   _____    ____        _       _     
ECHO  ^|  \/  ^| ^|  ____^| ^|  __ \  ^|  _ \      ^| ^|     ^| ^|    
ECHO  ^| \  / ^| ^| ^|__    ^| ^|  ^| ^| ^| ^|_) ^| __ _^| ^|_ ___^| ^|__  
ECHO  ^| ^|\/^| ^| ^|  __^|   ^| ^|  ^| ^| ^|  _ ^< / _` ^| __/ __^| '_ \ 
ECHO  ^| ^|  ^| ^|_^| ^|____ _^| ^|__^| ^| ^| ^|_) ^| (_^| ^| ^|^| (__^| ^| ^| ^|
ECHO  ^|_^|  ^|_(_)______(_)_____/  ^|____/ \__,_^|\__\___^|_^| ^|_^|                                                
ECHO ===============================================================                          
ECHO.          
ECHO.
ECHO 1 - Testing Tools
ECHO 2 - New Setup Tools
ECHO 3 - EXIT
ECHO.
SET /P M=Type 1, 2, or 3 then press ENTER:
IF %M%==1 GOTO TESTMENU
IF %M%==2 GOTO NEWMENU
IF %M%==3 GOTO Quit


:TESTMENU
cls
ECHO.
ECHO   _______        _     __  __                  
ECHO  ^|__   __^|      ^| ^|   ^|  \/  ^|                 
ECHO     ^| ^| ___  ___^| ^|_  ^| \  / ^| ___ _ __  _   _ 
ECHO     ^| ^|/ _ \/ __^| __^| ^| ^|\/^| ^|/ _ \ '_ \^| ^| ^| ^|
ECHO     ^| ^|  __/\__ \ ^|_  ^| ^|  ^| ^|  __/ ^| ^| ^| ^|_^| ^|
ECHO     ^|_^|\___^|^|___/\__^| ^|_^|  ^|_^|\___^|_^| ^|_^|\__,_^|                                                  
ECHO ===============================================================                          
ECHO.          
ECHO **************************** NOTE *****************************
ECHO Directories below are being used. To change use the menu option
ECHO  Production: %ProdLoc%  
ECHO  Test: %TestLoc%                                     
ECHO ***************************************************************
ECHO.
ECHO 1 - Set system for TEST
ECHO 2 - Set system for PRODUCTION
ECHO 3 - Change file locations
ECHO 4 - Patch Specific Setup
ECHO 5 - Main Menu
ECHO.
SET /P M=Type 1, 2, 3, 4 or 5 then press ENTER:
IF %M%==1 GOTO TEST
IF %M%==2 GOTO PROD
IF %M%==3 GOTO UPDLOC
IF %M%==4 GOTO PatchMenu
IF %M%==5 GOTO MENU                                                           


:NEWMENU
cls
CALL :check_Permissions
ECHO.
ECHO   _   _                  _____      _               
ECHO  ^| \ ^| ^|                / ____^|    ^| ^|              
ECHO  ^|  \^| ^| _____      __ ^| (___   ___^| ^|_ _   _ _ __  
ECHO  ^| . ` ^|/ _ \ \ /\ / /  \___ \ / _ \ __^| ^| ^| ^| '_ \ 
ECHO  ^| ^|\  ^|  __/\ V  V /   ____) ^|  __/ ^|_^| ^|_^| ^| ^|_) ^|
ECHO  ^|_^| \_^|\___^| \_/\_/   ^|_____/ \___^|\__^|\__,_^| .__/ 
ECHO                                              ^| ^|    
ECHO                                              ^|_^|    
ECHO ===============================================================                          
ECHO.          
ECHO **************************** NOTE *****************************
ECHO.
ECHO This will create new registry entries                                   
ECHO.
ECHO ***************************************************************
ECHO.
ECHO 1 - Yes
ECHO 2 - No
ECHO.
SET /P M=Type 1, or 2 then press ENTER: 
IF /I %M%==1 (
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0" /t REG_SZ /d "MED Import Library" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "C:\Program Files (x86)\Vista\Mobile Electronic Documentation\MEDImport.dll" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\FLAGS" /t REG_SZ /d "0" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "C:\Program Files (x86)\Vista\Mobile Electronic Documentation\" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\wow6432Node" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0" /t REG_SZ /d "MED Import Library" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "C:\Program Files (x86)\Vista\Mobile Electronic Documentation\MEDImport.dll" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\FLAGS" /t REG_SZ /d "0" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)
	reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "C:\Program Files (x86)\Vista\Mobile Electronic Documentation\" /f
	IF %ERRORLEVEL% NEQ 0 (
	 CALL :ERRORDSP "Error creating registry"
	 GOTO MENU
	)

	rem Let the user know the status
	Echo.
	ECHO Registeries have been created
	pause 
)
GOTO MENU


:UPDLOC
cls
ECHO.
ECHO   _____      _   _       __  __                  
ECHO  ^|  __ \    ^| ^| ^| ^|     ^|  \/  ^|                 
ECHO  ^| ^|__) ^|_ _^| ^|_^| ^|__   ^| \  / ^| ___ _ __  _   _ 
ECHO  ^|  ___/ _` ^| __^| '_ \  ^| ^|\/^| ^|/ _ \ '_ \^| ^| ^| ^|
ECHO  ^| ^|  ^| (_^| ^| ^|_^| ^| ^| ^| ^| ^|  ^| ^|  __/ ^| ^| ^| ^|_^| ^|
ECHO  ^|_^|   \__,_^|\__^|_^| ^|_^| ^|_^|  ^|_^|\___^|_^| ^|_^|\__,_^|
ECHO =============================================================== 
ECHO.          
ECHO.
ECHO 1 - Change Production location
ECHO 2 - Change Test location
ECHO 3 - Test Menu
ECHO.
SET /P M=Type 1, 2, or 3 then press ENTER:
IF %M%==1 GOTO PRODUPD
IF %M%==2 GOTO TESTUPD
IF %M%==3 GOTO TESTMENU

ECHO Set production location
ECHO
set /p ProdLoc="Production location: default is %ProdLoc% "
set /p TestLoc="Test location: default is %TestLoc% "
GOTO TESTMENU

:PRODUPD
cls
ECHO.
ECHO   _____               _            _   _             
ECHO  ^|  __ \             ^| ^|          ^| ^| (_)            
ECHO  ^| ^|__) ^| __ ___   __^| ^|_   _  ___^| ^|_ _  ___  _ __  
ECHO  ^|  ___/ '__/ _ \ / _` ^| ^| ^| ^|/ __^| __^| ^|/ _ \^| '_ \ 
ECHO  ^| ^|   ^| ^| ^| (_) ^| (_^| ^| ^|_^| ^| (__^| ^|_^| ^| (_) ^| ^| ^| ^|
ECHO  ^|_^|   ^|_^|  \___/ \__,_^|\__,_^|\___^|\__^|_^|\___/^|_^| ^|_^|
ECHO ===============================================================
ECHO.          
ECHO.                                                           
ECHO Current location set to:
ECHO %ProdLoc%
ECHO.
set /p ProdLoc="New location: "  
GoTo UPDLOC
                                                     
:TESTUPD
cls
ECHO.
ECHO   _______        _                 
ECHO  ^|__   __^|      ^| ^|            
ECHO     ^| ^| ___  ___^| ^|_  
ECHO     ^| ^|/ _ \/ __^| __^|  
ECHO     ^| ^|  __/\__ \ ^|_   
ECHO     ^|_^|\___^|^|___/\__^| 
ECHO ===============================================================
ECHO.          
ECHO.                                                           
ECHO Current location set to:
ECHO %TestLoc%
ECHO.
set /p TestLoc="New location: "  
GoTo UPDLOC                                                               
                                                               


:TEST
cls
CALL :check_Permissions
ECHO.
ECHO    _____           _                 
ECHO   / ____^|         ^| ^|                
ECHO  ^| (___  _   _ ___^| ^|_ ___ _ __ ___  
ECHO   \___ \^| ^| ^| / __^| __/ _ \ '_ ` _ \ 
ECHO   ____) ^| ^|_^| \__ \ ^|^|  __/ ^| ^| ^| ^| ^|
ECHO  ^|_____/ \__, ^|___/\__\___^|_^| ^|_^| ^|_^|
ECHO           __/ ^|                      
ECHO          ^|___/                       
ECHO ===============================================================
ECHO.          
ECHO. 
ECHO UnRegistering Production DLL
rem Un-register register
Regsvr32 /u /s "%ProdLoc%\MEDImport.dll"
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error unregistering %ProdLoc%\MEDImport.dll"
 GOTO TestMenu
)
ECHO Registering Test DLL
Rem Register
Regsvr32 /s "%TestLoc%\MEDImport.dll"
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error registering %TestLoc%\MEDImport.dll"
 GOTO TestMenu
)

ECHO Updating registries
rem Do the registry
reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "%TestLoc%\MEDImport.dll" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "%TestLoc%\" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "%TestLoc%\MEDImport.dll" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "%TestLoc%\" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP  "Error setting registry"
)

rem Let the user know the status
echo.
echo System is now set to Test
pause

GOTO TESTMENU

:PROD
cls
CALL :check_Permissions
ECHO.
ECHO    _____           _                 
ECHO   / ____^|         ^| ^|                
ECHO  ^| (___  _   _ ___^| ^|_ ___ _ __ ___  
ECHO   \___ \^| ^| ^| / __^| __/ _ \ '_ ` _ \ 
ECHO   ____) ^| ^|_^| \__ \ ^|^|  __/ ^| ^| ^| ^| ^|
ECHO  ^|_____/ \__, ^|___/\__\___^|_^| ^|_^| ^|_^|
ECHO           __/ ^|                      
ECHO          ^|___/                       
ECHO ===============================================================
ECHO.          
ECHO. 
ECHO UnRegistering Test DLL
rem Un-register and register
Regsvr32 /u /s "%TestLoc%\MEDImport.dll"
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error unregistering %TestLoc%\MEDImport.dll"
 GOTO TestMenu
)

ECHO Registering Production DLL
Regsvr32 /s "%ProdLoc%\MEDImport.dll"
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error registering %ProdLoc%\MEDImport.dll"
 GOTO TestMenu
)

ECHO Updating registries
rem Do the registry
reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "%ProdLoc%\MEDImport.dll" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
 GOTO TestMenu
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "%ProdLoc%\" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
 GOTO TestMenu
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\0\win32" /t REG_SZ /d "%ProdLoc%\MEDImport.dll" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
 GOTO TestMenu
)

reg add "HKEY_LOCAL_MACHINE\Software\Classes\Wow6432Node\TypeLib\{11E63EE0-3E4D-493B-9958-4A4093DA3184}\1.0\HELPDIR" /t REG_SZ /d "%ProdLoc%\" /f
IF %ERRORLEVEL% NEQ 0 (
 CALL :ERRORDSP "Error setting registry"
 GOTO TestMenu
)

rem Let the user know the status
echo.
echo System is now set to Prodcution
pause 

GOTO TESTMENU

:check_Permissions
 net session >nul 2>&1
 IF %ERRORLEVEL% NEQ 0 (
	CALL :ERRORDSP "Failure: Current permissions inadequate. Please run with elevated privelages"
	EXIT
 )
exit /b 

:ERRORDSP
CLS

ECHO.
ECHO   ______ _____  _____   ____  _____  
ECHO  ^|  ____^|  __ \^|  __ \ / __ \^|  __ \ 
ECHO  ^| ^|__  ^| ^|__) ^| ^|__) ^| ^|  ^| ^| ^|__) ^|
ECHO  ^|  __^| ^|  _  /^|  _  /^| ^|  ^| ^|  _  / 
ECHO  ^| ^|____^| ^| \ \^| ^| \ \^| ^|__^| ^| ^| \ \ 
ECHO  ^|______^|_^|  \_\_^|  \_\\____/^|_^|  \_\
ECHO =============================================================== 
ECHO.          
ECHO.
ECHO %1
pause
exit /b 

                                    
      
:Quit
CLS
ECHO ===============================================================
ECHO ================== PRESS ANY KEY TO CONTINUE ==================
ECHO ===============================================================
rem PAUSE>NUL
EXIT











