
unit fMED;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS

   10/6/2010 Herb - uncheck the "Enable runtime themes" checkbox in the Application page of the Project Options.
           http://www.drbob42.com/examines/examin88.htm
           to eliminate the checkbox shadow with XM theme.  Use Classical instead.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MSXML_TLB, uTemplates, uTemplateFields, uDB, uTemplateXML, XMLUtils, ComCtrls,
  Menus, ExtCtrls, ImgList, uCore, uNote, ActnList, StdActns, fAboutMED, ORFn,
  Trpcb, RpcConf1, fGetPatList, registry, uPatient, ORCtrls, uFindItems, fPrint,
  fMedSettings, ToolWin, fGetPat, VA508AccessibilityManager,Constants,
  System.Actions, System.ImageList, HtmlHelpViewer, ORExtensions;

const
 UM_INITIALIZE = (WM_USER + 9246);

type

  EditModes = (emActive, emLocked, emDisabled);

  TfrmMain = class(TForm)
    pgTabs: TPageControl;
    tabSummary: TTabSheet;
    tabNotes: TTabSheet;
    stMain: TStatusBar;
    mnuMain: TMainMenu;
    mnuFile: TMenuItem;
    mnuSelectNewPatient: TMenuItem;
    mnuRetrievePatientList: TMenuItem;
    mnuExit: TMenuItem;
    N2: TMenuItem;
    pnlPatInfo: TPanel;
    mnuHelp: TMenuItem;
    mnuContents: TMenuItem;
    N1: TMenuItem;
    mnuAboutMED: TMenuItem;
    imgIcons: TImageList;
    pnlNoteTempSel: TPanel;
    pnlNote: TPanel;
    lblSpace: TLabel;
    spltVertTempNote: TSplitter;
    mnuAction: TMenuItem;
    mnuDeleteNote: TMenuItem;
    popAction: TPopupMenu;
    popDeleteNote: TMenuItem;
    actItems: TActionList;
    actDeleteNote: TAction;
    actEditNote: TAction;
    mnuEditNote: TMenuItem;
    popEditNote: TMenuItem;
    actCut: TEditCut;
    mnuEdit: TMenuItem;
    mnuEditCut: TMenuItem;
    actCopy: TEditCopy;
    N3: TMenuItem;
    popCut: TMenuItem;
    popCopy: TMenuItem;
    mnuEditCopy: TMenuItem;
    actPaste: TEditPaste;
    popPaste: TMenuItem;
    mnuEditPaste: TMenuItem;
    actUndo: TEditUndo;
    N4: TMenuItem;
    mnuEditUndo: TMenuItem;
    mnuView: TMenuItem;
    mnuViewSummTab: TMenuItem;
    mnuViewNoteTab: TMenuItem;
    actSelectAll: TEditSelectAll;
    N5: TMenuItem;
    SelectAll1: TMenuItem;
    N6: TMenuItem;
    popSelectAll: TMenuItem;
    imgMenuIcon: TImageList;
    pnlFindInHealthSumm: TPanel;
    lblFind: TLabel;
    fndDlg: TFindDialog;
    actFind: TAction;
    Find1: TMenuItem;
    N7: TMenuItem;
    cmbFind: TComboBox;
    Find2: TMenuItem;
    actPrint: TAction;
    N8: TMenuItem;
    Print1: TMenuItem;
    lblNotes: TLabel;
    trvNotes: TTreeView;
    pnlTemplates: TPanel;
    lstTemplates: TListBox;
    lblTemplates: TLabel;
    spltHorNotesTempl: TSplitter;
    pnlCreateTemplate: TPanel;
    btnCreateNote: TButton;
    actRetPatList: TAction;
    mnuCompactDB: TMenuItem;
    Tools1: TMenuItem;
    //mnuManageSettings: TMenuItem;
    N9: TMenuItem;
    memNote: ORExtensions.TRichEdit;
    mnuManageSettings: TMenuItem;
    tabScratch: TTabSheet;
    mnuViewScratchTab: TMenuItem;
    memScratch: ORExtensions.TRichEdit;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    stPatDOB: TStaticText;
    stPatSSN: TStaticText;
    stPatName: TStaticText;
    pnlScratchPad: TPanel;
    VA508CompAccScratchPad: TVA508ComponentAccessibility;
    VA508CompAccNote: TVA508ComponentAccessibility;
    { TODO -oHERB -c508 : TMemo was not being read by JAWS so it was replaced with a TRichEdit }
//    memPatSummary: TMemo;
    memPatSummary: ORExtensions.TRichEdit;
    actSaveNote: TAction;
    mnuSaveNote: TMenuItem;
    SaveNote1: TMenuItem;
    SaveNote2: TMenuItem;
    tmrSave: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuSelectNewPatientClick(Sender: TObject);
    procedure trvNotesCollapsing(Sender: TObject; Node: TTreeNode;
      var AllowCollapse: Boolean);
    procedure trvNotesChange(Sender: TObject; Node: TTreeNode);
    procedure memNoteChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure trvNotesEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure actDeleteNoteUpdate(Sender: TObject);
    procedure trvNotesDeletion(Sender: TObject; Node: TTreeNode);
    procedure actDeleteNoteExecute(Sender: TObject);
    procedure actEditNoteUpdate(Sender: TObject);
    procedure actEditNoteExecute(Sender: TObject);
    procedure mnuViewSummTabClick(Sender: TObject);
    procedure mnuViewNoteTabClick(Sender: TObject);
    procedure mnuAboutMEDClick(Sender: TObject);
    procedure AddToTemplateList(strFileName, strName: string);
    procedure GetPatList();
    procedure trvNotesChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure cmbFindChange(Sender: TObject);
    procedure cmbFindKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure actFindUpdate(Sender: TObject);
    procedure actFindExecute(Sender: TObject);
    procedure fndDlgFind(Sender: TObject);
    procedure fndDlgClose(Sender: TObject);
    procedure actPrintExecute(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure mnuContentsClick(Sender: TObject);
    procedure btnCreateNoteClick(Sender: TObject);
    procedure lstTemplatesDblClick(Sender: TObject);
    procedure lstTemplatesClick(Sender: TObject);
    procedure actRetPatListExecute(Sender: TObject);
    procedure actRetPatListUpdate(Sender: TObject);
    procedure mnuCompactDBClick(Sender: TObject);
    procedure mnuManageSettingsClick(Sender: TObject);
    procedure memNoteProtectChange(Sender: TObject; StartPos,
      EndPos: Integer; var AllowChange: Boolean);
    procedure memNoteKeyPress(Sender: TObject; var Key: Char);
    procedure trvNotesMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mnuViewScratchTabClick(Sender: TObject);
    procedure memScratchChange(Sender: TObject);
    procedure memScratchEnter(Sender: TObject);
    procedure pgTabsChange(Sender: TObject);
    procedure actSaveNoteExecute(Sender: TObject);
    procedure actSaveNoteUpdate(Sender: TObject);

  private
    OldSPProc: TWndMethod;
    flHealthSumm: TFindItems;
    Notes: TNoteRecordArr;
    PendingNode: TTreeNode;
    ImportedNode: TTreeNode;
    blnCanChangeProtected: boolean;
    pnlScratchPadBtnCnt: Integer; // keeps track of how many buttons on panel
    pnlScratchPadBtnNext: Integer; // position for next button to be put
    pnlScratchPadBtnWidthFactor: Integer; // fudge factor for computing button width = lenght * fudge
    fLastSearchPOS: Integer;
    procedure MEDExc(Sender: TObject; E: Exception);
    procedure ScratchPadClick(Sender: TObject);
    procedure Finish();
    procedure SelectPat();
    procedure CreateTree(ntList: TNoteRecordArr);
    procedure CreateHealthSearch(pat: TPatRecord);
    procedure ShowPatData();
    procedure SaveWindowPos();
    procedure GetWindowPos();
    function SaveNote(ntSave: TNoteRecord): boolean;
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    procedure ChangeEditMode(Mode: EditModes);
    procedure ClearEdit();
    procedure MarkProtected();
    procedure ManageSettings();
    procedure copyTemplatesFrom(Path: string);
    procedure RichEditMessage(var Msg: TMessage);
     procedure SetSaveInterval(Secs :Integer);
     procedure UMInitiate(var Message: TMessage);   message UM_INITIALIZE;
  public
    ntCurr: TNoteRecord;
  end;

function RenderTemplate(strXML: string): string;


var
  frmMain: TfrmMain;

implementation

uses
  VA508AccessibilityRouter;

procedure TfrmMain.ShowPatData();
begin
  if CurrPatient = nil then Exit;
  //Release current note
  ntCurr := nil;
  //patient info
  stPatName.Caption := CurrPatient.Name;
  stPatSSN.Caption := FormatSSN(CurrPatient.SSN);
  stPatDOB.Caption := CurrPatient.DOB;
  memPatSummary.Lines.Text := CurrPatient.HealthSumm;
  memScratch.Tag := 1;
  memScratch.Lines.Text := CurrPatient.ScratchPad;
  memScratch.Tag := 0;
  //Patient notes
  Notes := GetNotesArr(CurrPatient.DFN);
  ChangeEditMode(emDisabled);
  //Create our tree
  CreateTree(Notes);
  CreateHealthSearch(CurrPatient);
end;

procedure TfrmMain.RichEditMessage(var Msg: TMessage);
begin
  //handle messages
  case Msg.Msg of
    WM_KEYDOWN, WM_KEYUP:
      begin
      { TODO -oherb -c508 : Need to be able to exit Rich Edit field - use Esc key.
                            and set focus on the page control}
        if (Msg.WParam = 27) then
          stPatName.SetFocus;
      //Is this one of the "clipboard" keys (e.g. x or c with control held down?
        if (Msg.WParam = 88) or (Msg.WParam = 67) then
        begin
        //Is the control key held?
          if HiWord(GetKeyState(VK_CONTROL)) <> 0 then
          begin
            { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//            ShowMessage('Copy and Paste from ScratchPad is not allowed');
            { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//            MessageBox(0, PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//            MessageBox( frmMain.Handle , PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
            MessageBox( self.Handle , PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
            Msg.Result := 0;
            Exit;
          end;
        end;
      end;
    WM_CUT, WM_COPY:
      begin
      //Disable Cut and Copy
        { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//        ShowMessage('Copy and Paste from ScratchPad is not allowed');
        { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//        MessageBox(0, PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//        MessageBox( frmMain.Handle, PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
        MessageBox( self.Handle, PChar('Copy and Paste from ScratchPad is not allowed'), 'Error', MB_OK);
        Exit;
      end;
  end;

  //Send message to original procedure
  OldSPProc(Msg);
end;

procedure TfrmMain.CreateHealthSearch(pat: TPatRecord);
var
  sum: TStrings;
  strItem: string;
  iLen: integer;
  line: integer;
  fiNew: TFindItem;
  iPos: integer;
begin
  //Clear the text and list
  cmbFind.Text := '';
  cmbFind.Clear;

  //Show our items?
  if not assigned(pat) then
  begin
    lblFind.Enabled := False;
    cmbFind.Enabled := False;
    Exit;
  end;

  //Create our find list
    //If we have one release it's resources
  FreeAndNil(flHealthSumm);
    //Create it
  flHealthSumm := TFindItems.Create;

  //Add our items
  sum := memPatSummary.Lines;

  //Search the items
  for line := 0 to sum.Count - 1 do
  begin
        //Get the string and it's length
    strItem := sum[line];
    iLen := Length(strItem);
        //Match a section signature?
    if (iLen > 0) then
    begin
      if (strItem[1] = '-') and (strItem[iLen] = '-') then
      begin
                  //Remove preceding and trailing dashes
        strItem := Trim(StringReplace(strItem, '-', '', [rfReplaceAll]));
                  //Remove duplicate spaces
        strItem := StringReplace(strItem, '  ', ' ', [rfReplaceAll]);
                  //Add this?
        if (strItem <> '') then
        begin
          iPos := cmbFind.Items.Add(strItem);
          fiNew := flHealthSumm.CreateItem(line, 0);
          cmbFind.Items.Objects[iPos] := fiNew;
        end;
      end;
    end;
  end;

  //If we have any enable our search
  lblFind.Enabled := True;
  cmbFind.Enabled := True;


end;

procedure TfrmMain.CreateTree(ntList: TNoteRecordArr);
var
  i: integer;
  ntItem: TNoteRecord;
  ndNote: TTreeNode;
  useNode: TTreeNode;
  imageIdx: integer;
begin
  //Release current note
  ntCurr := nil;

  //Have our nodes?
  if not assigned(PendingNode) or not assigned(ImportedNode) then
  begin
        //Create our Pending and Imported Node
    PendingNode := trvNotes.Items.AddChild(nil, 'Pending Notes');
    PendingNode.ImageIndex := 0;
    PendingNode.SelectedIndex := 0;

    ImportedNode := trvNotes.Items.AddChild(nil, 'Imported Notes');
    ImportedNode.ImageIndex := 1;
    ImportedNode.SelectedIndex := 1;
  end;

  //Clear our notes
  PendingNode.DeleteChildren;
  ImportedNode.DeleteChildren;

  //Get our Notes
  if assigned(ntList) then
  begin
    for i := Low(ntList) to High(ntList) do
    begin
            //Get the item
      ntItem := ntList[i];
            //Add this item as Pending or Imported?
      if not ntItem.Imported then
      begin
        useNode := PendingNode;
        imageIdx := PendingNode.ImageIndex;
      end
      else
      begin
        useNode := ImportedNode;
        imageIdx := ImportedNode.ImageIndex;
      end;
            //Add it
      ndNote := trvNotes.Items.AddChild(useNode, ntItem.Caption);
      ndNote.ImageIndex := imageIdx;
      ntItem.Data := ndNote;
      ndNote.Data := ntItem;
    end;
  end;

  //Expand them
  PendingNode.Expand(True);
  ImportedNode.Expand(True);

end;

procedure TfrmMain.MarkProtected();
var
  i, p1, p2, offset, selPos, selLen: integer;
  s, sfind: string;

begin
  //Store our selection values
  selPos := memNote.SelStart;
  selLen := memNote.SelLength;

  //Reset our values
  memNote.SelStart := 0;
  memNote.SelLength := 0;

  //Find our protected entries (data objects) and mark them as such
  for i := 0 to memNote.Lines.Count do
  begin
        //Reset
    offset := 0;
        //Get the line
    s := memNote.Text;
        //Copy our find
    sfind := s;
        //Find our matches
    while 1 = 1 do
    begin
              //Find our first item
      p1 := pos('|', sfind);
              //Have one?
      if p1 = 0 then break;
              //Get our second
      sfind := Copy(sfind, p1 + 1, Length(sfind));
      p2 := pos('|', sfind);
              //Have one?
      if p2 = 0 then break;
              //Now select our text and apply our attributes (including protected)
      memNote.SelStart := offset + (p1 - 1);
      memNote.SelLength := p2 + 1;
      memNote.SelAttributes.Style := [fsBold, fsUnderline];

                { TODO -oHerb -cSACC : Remove hard coded color for SACC from Brian }
//                memNote.SelAttributes.Color := clGreen;
      memNote.SelAttributes.Color := clHighlight;


      memNote.SelAttributes.Protected := True;
              //Now change our offset
      offset := offset + p1 + p2;
              //Copy our string
      sfind := Copy(sfind, p2 + 1, Length(sfind));
    end;
  end;
  //Reset the selection
  memNote.SelStart := selPos;
  memNote.SelLength := selLen;


end;

procedure TfrmMain.ClearEdit();
begin
  //Flag that we can change
  blnCanChangeProtected := True;
  //Clear the edit bar
  memNote.Text := '';
  //Flag that we can change
  blnCanChangeProtected := False;
end;

procedure TfrmMain.ChangeEditMode(Mode: EditModes);
begin
  //What mode are we in?
  case Mode of
    emActive:
      begin
        memNote.ReadOnly := False;
        memNote.Color := clWhite;
        memNote.Enabled := True;
      end;
    emLocked:
      begin
        memNote.ReadOnly := True;
        memNote.Color := clInfoBk;
        memNote.Enabled := True;
      end;
    emDisabled:
      begin
        ClearEdit();
        memNote.Color := clInactiveBorder;
        memNote.ReadOnly := True;
        memNote.Enabled := False;
      end;
  end
end;

procedure TfrmMain.AddToTemplateList(strFileName, strName: string);
var
  strComp: string;
  { TODO -oherb -c508 : Replace TToolBar and TToolButton with TPanel and TButton }
//  btnNew:TToolButton;
  btnNew: TButton;
  va508Helper: TVA508ComponentAccessibility;

begin
  //Get the comparison string
  strComp := LowerCase(strFileName);
  //Determine which list to add this to
  if Copy(strComp, 1, 11) = 'scratchpad_' then
  begin
        //Add to our scratchpad tools menu

        { TODO -oherb -c508 : Replace TToolBar and TToolButton with TPanel and TButton }
//        btnNew := TToolButton.Create(tbScratchPad);
    btnNew := TButton.Create(pnlScratchPad);

        //Set properties
        { TODO -oherb -c508 : Replace TToolBar and TToolButton with TPanel and TButton }
//        btnNew.Parent := tbScratchPad;
    btnNew.Parent := pnlScratchPad;


    btnNew.Hint := strName;
    btnNew.TabStop := True;

        { TODO -oherb -c508 :
            Replace TToolBar and TToolButton with TPanel and TButton }
//        btnNew.AutoSize := True;
//        btnNew.Style := tbsButton;
    btnNew.Caption := StringReplace(strName, '&', '&&', [rfReplaceAll]);
    btnNew.Height := pnlScratchPad.Height;
    btnNew.Width := length(btnNew.Caption) * pnlScratchPadBtnWidthFactor; // guess here for now
    btnNew.Top := pnlScratchPad.Top;
    btnNew.Left := pnlScratchPadBtnNext;
    pnlScratchPadBtnCnt := pnlScratchPadBtnCnt + 1;
    pnlScratchPadBtnNext := pnlScratchPadBtnNext + btnNew.Width;

    va508Helper := TVA508ComponentAccessibility.Create(frmMain);
    va508Helper.Component := btnNew;
    va508Helper.Caption := btnNew.Caption;

    btnNew.OnClick := ScratchPadClick;

  end
  else
  begin
        //Add to our list
    lstTemplates.Items.Add(strName);
  end;


end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  strName: string;
  sr: TSearchRec;
  blnT: boolean;
  fileCont: TStringList;
  args: integer;
  arg: string;
  frmSplash: TfrmAboutMED;
  Enum: TComponentEnumerator;
begin
  {
  blj 9 June 2009 - 508
  We've changed the patient name, DOB, and SSN labels from labels to static
  text components.  Now, we need to go through and see if a screen reader is
  running.  If it is, then we need to enable the tab stops for the static text
  components.
  }
        // do not say group box below
//    pnlPatInfo.TabStop := ScreenReaderSystemActive;
//    pnlPatInfo.TabOrder := 0;
    stPatName.TabStop := ScreenReaderSystemActive;
    stPatName.TabOrder := 0;
    stPatSSN.TabStop := ScreenReaderSystemActive;
    stPatSSN.TabOrder := 1;
    stPatDOB.TabStop := ScreenReaderSystemActive;
    stPatDOB.TabOrder := 2;



  { TODO -oherb -c508 :
Replace TToolBar and TToolButton with TPanel and TButton
No TButton.Style property }

  pnlScratchPadBtnCnt := 0; // no buttons on pannel yet
  pnlScratchPadBtnNext := pnlScratchPad.Left; // first button at the left side

//  pnlScratchPadBtnWidthFactor := 10; // not sure what the fudge factor should be

  { TODO -oHerb -c508 : try changing the button width here - see if this will work }
  pnlScratchPadBtnWidthFactor := 8; // not sure what the fudge factor should be


  Enum := GetEnumerator;
  try
    while Enum.MoveNext do
      if Enum.Current is TStaticText then
        with Enum.Current as TStaticText do
          TabStop := ScreenReaderSystemActive;
  finally
    FreeAndNil(Enum);
  end;

  //Initialize our Exception handling
  Application.OnException := MEDExc;

  //Status
  CurrStatusBar := Self.stMain;
  CurrStatus := Self.stMain.Panels[0];

  //Application Messages
  Application.OnMessage := AppMessage;
  //Hook messages from our ScratchPad to disable clipboard
    //Store the old proc
  OldSPProc := memScratch.WindowProc;
    //And set the new one
  memScratch.WindowProc := RichEditMessage;

  //Enable HTML Help
 // mHHelp := THookHelpSystem.Create('MED.chm', '', htHHAPI);

  //Get our command line arguments for server and port if any
  for args := 1 to ParamCount do
  begin
        //Get this item
    arg := LowerCase(ParamStr(args));
        //Is this a server/port item?
    if LowerCase(copy(arg, 1, 2)) = 's=' then
      Server := Copy(arg, 3, Length(arg));
    if LowerCase(copy(arg, 1, 2)) = 'p=' then
      Port := Copy(arg, 3, Length(arg));
    if LowerCase(copy(arg, 1, 9)) = '/settings' then
      blnManageSettings := True;
    if LowerCase(copy(arg, 1, 5)) = '/demo' then
      blnIsDemo := True;
  end;

  //Create our splash screen
  frmSplash := TfrmAboutMED.Create(Self);
  frmSplash.ShowSplash;
  //Allow the window to process messages
  Application.ProcessMessages;

  //Retrieve our window position information
  GetWindowPos();

  //Connect to our database
  blnT := DBConnect(AppDataPath + '\db\MED.mdb');
  if blnT = False then
  begin
        { TODO -oHerb -c508 :
Replace MessageDlg with MessageBox per Brian -- Could not do it here
becasuse of the connection to the help file.  Brian looking into this. }
//        MessageDlg('Error opening the ''' + GetCurrentDir + '\db\MED.mdb' + ''' database file',mtError,[mbOK,mbHelp],1920);
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(Handle, PChar('Error opening the ' + GetCurrentDir + '\db\MED.mdb' + ' database file'),
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmMain.Handle, PChar('Error opening the ' + GetCurrentDir + '\db\MED.mdb' + ' database file'),
    MessageBox( self.Handle, PChar('Error opening the ' + AppDataPath + '\db\MED.mdb' + ' database file'),
      'ERROR - Unable to open Database', MB_ICONERROR or MB_OK);
    QuitApp(False);
    Exit;
  end;

  //Check if DB updated needed (TIU*1.0*315)
  TIU315DBFix;

  //Get our Settings
  GetSettings();

  //Set Save Timer Interval
  SetSaveInterval(SaveInterval);

  //Flush our notes
  DeleteDaysOldNotes(7);
  //And patients
  DeletePatsWithNoNotes(7);

  //Create our Treeview items
  CreateTree(nil);

  //Copy our templates
  CopyTemplatesFrom(TemplateUpdatePath);

  //Get our templates
  if FindFirst(AppDataPath + '\Templates\*.txml', faAnyFile, sr) = 0 then
  begin
    try
             //Get the file contents
      fileCont := TStringList.Create;
             { TODO -oHerb -cSACC : try/finally for SACC from Brian }
      try
        fileCont.LoadFromFile(AppDataPath + '\Templates\' + sr.Name);
               //Now add the template
        strName := AddTemplateXML(fileCont.Text);
      finally
               //Done
        fileCont.Free;
      end; // end try/finally

             //Have one?
      if strName <> '' then
        AddToTemplateList(sr.Name, strName);


      while FindNext(sr) = 0 do
      begin
                 //Get the file contents
        fileCont := TStringList.Create;
                 { TODO -oHerb -cSACC : try/finally for SACC from Brian }
        try
          fileCont.LoadFromFile(AppDataPath + '\Templates\' + sr.Name);
                   //Now add the template
          strName := AddTemplateXML(fileCont.Text);
        finally
                   //Done
          fileCont.Free;
        end; // end try/finally

                 //Have one?
        if strName <> '' then
          AddToTemplateList(sr.Name, strName);
      end; // end while FindNext
    finally
             { TODO -oHerb -cSACC : add FindClose for SACC from Brian }
      FindClose(sr);
    end; // end try/finally FindFirst/FindClose
  end // end if FindFirst
  else
  begin
            { TODO -oHerb -cSACC : add FindClose for SACC from Brian }
    FindClose(sr); // closes find if first fails
    lstTemplates.Clear;
    lstTemplates.Items.Add('No Templates Found');
  end; // end else FindFirst

  //Have any scratchpad templates?
  { TODO -oherb -c508 :
      Replace TToolBar and TToolButton with TPanel and TButton }
//  if tbScratchPad.ButtonCount = 0 then
//    tbScratchPad.Visible := False;
  if pnlScratchPadBtnCnt = 0 then
    pnlScratchPad.Visible := False;

  //Wait 2 seconds
  sleep(2000);

  //Close our splash screen
  frmSplash.Close;

  //Everything ok?
  if CriticalErr <> '' then
  begin
        //Show the error
          { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian }
//          MessageDlg('A critical error has been encountered.  MED will now shut down' + CRLF + CRLF + 'Error:' + CriticalErr,mtError,[mbOK],0);
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(Handle, PChar('A critical error has been encountered.  MED will now shut down' +
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmMain.Handle, PChar('A critical error has been encountered.  MED will now shut down' +
    MessageBox( self.Handle, PChar('A critical error has been encountered.  MED will now shut down' +
      CRLF + CRLF + 'Error:' + CriticalErr), 'Critical Error Occured', MB_ICONERROR or MB_OK);
        //Quit
    QuitApp;
    Exit;
  end;

  //Settings?
  if (blnManageSettings) then
    ManageSettings(); //Show the Settings form
  //Compact?
  if (SuggestCompact = True) and (GetFileSizeMB(AppDataPath + '\db\MED.mdb') > CompactAtSize) then
  begin
        { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian }
        //Ask if the user wants to compact.
    if //MessageDlg('The MED database is larger than ' + IntToStr(CompactAtSize) + ' MB' + CRLF + 'It is suggested that you compact the database.' + CRLF + CRLF + 'Compact now?',mtConfirmation,[mbYes, mbNo],0)
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      MessageBox(Handle, PChar('The MED database is larger than ' + IntToStr(CompactAtSize) + ' MB' + CRLF + 'It is suggested that you compact the database.' + CRLF + CRLF + 'Compact now?'), 'Compact Database', MB_ICONQUESTION or MB_YESNO) = mrYes then
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmMain.Handle, PChar('The MED database is larger than ' + IntToStr(CompactAtSize) + ' MB' + CRLF + 'It is suggested that you compact the database.' + CRLF + CRLF + 'Compact now?'), 'Compact Database', MB_ICONQUESTION or MB_YESNO) = mrYes then
      MessageBox( self.Handle, PChar('The MED database is larger than ' + IntToStr(CompactAtSize) + ' MB' + CRLF + 'It is suggested that you compact the database.' + CRLF + CRLF + 'Compact now?'), 'Compact Database', MB_ICONQUESTION or MB_YESNO) = mrYes then
    begin
              //Run the compact option
      mnuCompactDBClick(nil);
      Exit;
    end;
  end;

  //Show our patient select dialog
  //SelectPat();
 PostMessage(Handle, UM_INITIALIZE, 0, 0);

end;

{$R *.DFM}

function RenderTemplate(strXML: string): string;
var
  //tmpForm:TfrmTemplateDialog;
  xmlTemplate: IXMLDOMDocument;
  tmpTemplate: TTemplate;
  RootElement: IXMLDOMElement;
  FXMLElement: IXMLDOMNode;
  fldNew: TTemplateField;
  Children: IXMLDOMNodeList;
  Child: IXMLDOMNode;
  count: integer;
  i: integer;
begin
  //Clear Fields
  ClearTemplateFields();

  //Open our template
  xmlTemplate := CoDOMDocument.Create;
  xmlTemplate.preserveWhiteSpace := TRUE;
  xmlTemplate.loadXML(strXML);

  //Error?
  if xmlTemplate.Get_parseError.Get_errorCode <> 0 then
  begin
    Result := '';
    Exit;
  end;

  //Create our template
  RootElement := xmlTemplate.documentElement;
  FXMLElement := FindXMLElement(RootElement, XMLTemplateTag);
  tmpTemplate := TTemplate.CreateFromXML(FXMLElement, '12345');

  //Create our fields
  try
    FXMLElement := FindXMLElement(RootElement, XMLTemplateFieldsTag);
    if assigned(FXMLElement) then
    begin
          //Get our children
      Children := FXMLElement.Get_childNodes;
      if assigned(Children) then
      begin
        count := Children.Get_length;
        for i := 0 to count - 1 do
        begin
          Child := Children.Get_item(i);
          if assigned(Child) and (CompareText(Child.Get_nodeName, 'FIELD') = 0) then
          begin
            fldNew := TTemplateField.Create(Child);
            AddTemplateField(fldNew);
          end;
        end;
      end;
    end;
  finally
  end;

  //Get the note
  Result := tmpTemplate.Text;
  { TODO -oHerb -cSACC : free tempTemplate for SACC from Brian }
  tmpTemplate.Free;
end;

procedure TfrmMain.mnuExitClick(Sender: TObject);
begin
  //Attempt to close the form
  Self.Close;
end;

procedure TfrmMain.mnuSelectNewPatientClick(Sender: TObject);
begin
  //Show our patient select dialog
  SavePat(CurrPatient);
  SelectPat();
end;

procedure TfrmMain.trvNotesCollapsing(Sender: TObject; Node: TTreeNode;
  var AllowCollapse: Boolean);
begin
  //Disable collapsing of a node
  AllowCollapse := false;
end;


procedure TfrmMain.trvNotesChange(Sender: TObject; Node: TTreeNode);
var
  ntNote: TNoteRecord;
begin
  //Remove reference
  ntCurr := nil;

  //Does this node have a pointer to a TNoteRecord object?
  if not assigned(Node.Data) then
  begin
        //Clear current
    ntCurr := nil;
    ChangeEditMode(emDisabled);
  end
  else
  begin
        //Get the item
    ntNote := Node.Data;
        //Set the text
    ClearEdit();
    memNote.Text := ntNote.Text;
        //Mark our protected contents
    MarkProtected();
        //Saved?
    if ntNote.Saved then
    begin
      ChangeEditMode(emLocked);
    end
    else
    begin
      ChangeEditMode(emActive);
    end;
        //Set it
    ntCurr := ntNote;
  end;
end;

function TfrmMain.SaveNote(ntSave: TNoteRecord): boolean;
begin
  //Default
  Result := False;
  //Have anything?
  if not assigned(ntSave) then
    Exit;
  //Save the note
  if not ntSave.SaveNote() then
  begin
        //Show the error
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(Self.Handle, PChar('There was an error saving this note' + CRLF + ntSave.Caption), PChar('Note Save Error'), MB_OK + MB_ICONWARNING);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmMain.Handle, PChar('There was an error saving this note' + CRLF + ntSave.Caption), PChar('Note Save Error'), MB_OK + MB_ICONWARNING);
    MessageBox( self.Handle, PChar('There was an error saving this note' + CRLF + ntSave.Caption), PChar('Note Save Error'), MB_OK + MB_ICONWARNING);
        //Return an error
    Result := False;
  end
  else
  begin
    Result := True;
    ntSave.Saved := True;
  end;
end;

procedure TfrmMain.memNoteChange(Sender: TObject);
begin
  //Do we have a note item?
  if assigned(ntCurr) then
  begin
    ntCurr.Saved := False;
    ntCurr.Text := memNote.Text;
  end;
end;

procedure TfrmMain.Finish();
begin
  //Save our Window Position Info
  SaveWindowPos();
  //Save Note      *SMT*
  SaveNote(ntCurr);
  //Save patient
  SavePat(CurrPatient);
  //Clear our notes to ensure they are saved
  trvNotes.Items.Clear;
  //Cleanup any find results
  FreeAndNil(flHealthSumm);
  //And restore original procedures
  memScratch.WindowProc := OldSPProc;
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //Finish up
  Finish();
  //Quit the application.
  QuitApp();
end;

procedure TfrmMain.trvNotesEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  //Don't allow edit of nodes
  AllowEdit := False;
end;

procedure TfrmMain.actDeleteNoteUpdate(Sender: TObject);
begin
  //Can we delete a note?
  if assigned(ntCurr) then
    actDeleteNote.Enabled := True
  else
    actDeleteNote.Enabled := False;
end;

procedure TfrmMain.trvNotesDeletion(Sender: TObject; Node: TTreeNode);
var
  ntNote: TNoteRecord;
begin
  //Does our node have a note?
  if assigned(Node.Data) then
  begin
        //Set the note
    ntNote := Node.Data;
        //Saved?
    if not ntNote.Saved then
      SaveNote(ntNote);
        //Free the note
    ntNote.Free;
  end;
end;

procedure TfrmMain.actDeleteNoteExecute(Sender: TObject);
var
  ndRef: TTreeNode;
begin
  //Verify we have a note to delete
  if not assigned(ntCurr) then Exit;
  //Ensure that they want to delete this note
  { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//  if MessageBox(Self.Handle, PChar(ntCurr.Caption + CRLF + CRLF + 'Delete this note?'), PChar('Confirm Deletion'), MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2) = IDNO then
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//  if MessageBox( frmMain.Handle, PChar(ntCurr.Caption + CRLF + CRLF + 'Delete this note?'), PChar('Confirm Deletion'), MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2) = IDNO then
  if MessageBox( self.Handle, PChar(ntCurr.Caption + CRLF + CRLF + 'Delete this note?'), PChar('Confirm Deletion'), MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2) = IDNO then
    Exit;

  //Delete the current note
  ntCurr.DeleteNote();
  //Get our node that holds a pointer
  ndRef := ntCurr.Data;
  //Flag this as saved so it isn't saved
  ntCurr.Saved := True;
  //Release our Current Note reference
  ntCurr := nil;
  //Have one?
  if assigned(ndRef) then
  begin
        //Delete the node... it will handle deleting this object
    ndRef.Delete;
  end
  else
    ndRef.Free; //Delete ourself then


end;

procedure TfrmMain.actEditNoteUpdate(Sender: TObject);
begin
  //Default to disabled
  actEditNote.Enabled := False;
  //Can we edit a note?
  if assigned(ntCurr) then
  begin
    if ntCurr.Saved = True then actEditNote.Enabled := True;
  end;
end;

procedure TfrmMain.actEditNoteExecute(Sender: TObject);
begin
  //Verify we have a note to edit
  if not assigned(ntCurr) then Exit; //No.
  //Edit this note
  ntCurr.Saved := False;
  //Enable editing
  ChangeEditMode(emActive);
  memNote.Enabled := True;
end;

procedure TfrmMain.mnuViewSummTabClick(Sender: TObject);
begin
  //View our Summary tab
  pgTabs.ActivePage := tabSummary;
  pgTabsChange(Sender);
end;


{ TODO -oHerb -c508 : Need to tell jaws what tab we are on. }
procedure TfrmMain.pgTabsChange(Sender: TObject);
begin
  if ScreenReaderSystemActive  then
    GetScreenReader.Speak(pgTabs.ActivePage.Caption);

  //*CB* Tools only visible on Notes Tab.
  if pgTabs.TabIndex = 2 then
    mnuAction.Visible := true
  else
    mnuAction.Visible := false;

end;

procedure TfrmMain.mnuViewNoteTabClick(Sender: TObject);
begin
  //View our Notes tab
  pgTabs.ActivePage := tabNotes;
  pgTabsChange(Sender);
end;

procedure TfrmMain.mnuAboutMEDClick(Sender: TObject);
var
  frmAbout: TfrmAboutMED;
begin
  frmAbout := TfrmAboutMED.Create(Self);
  frmAbout.ShowAbout;
  //frmAbout.ShowModal;
  { TODO -oHerb -cSACC : free form after use for SACC from Brian }
  frmAbout.Free;
end;

procedure TfrmMain.SelectPat();
begin
  //Clear current patient data
  CreateTree(nil);
  CreateHealthSearch(nil);
    //Any find results?
  FreeAndNil(flHealthSumm);
    //Clear
  PatSelStatus := 0;
  while PatSelStatus <> SELPAT_SELECTED do
  begin
          //Get the patient
    SelectPatient(Self);
          //Quit?
    if (PatSelStatus = SELPAT_CANCELLED) then
    begin
      CurrPatient := nil;
      QuitApp();
      break;
    end;
          //Get Patient List?
    if (PatSelStatus = SELPAT_GETPATS) then
    begin
                //Get the patient list
      GetPatList();
    end;
          //Reselect?
    if (PatSelStatus = SELPAT_RESELECT) then
    begin
               //Will reselect during while
    end;
  end;

  //Have one?
  if assigned(CurrPatient) then
  begin
        //Show the data
    ShowPatData();
        //Default back to our summary page
    pgTabs.ActivePage := tabSummary;
  end;
end;

procedure TfrmMain.GetPatList();
var
  patGet: TfrmGetPat;
begin
  //Open the Patient List form
  patGet := TfrmGetPat.Create(Self);
  patGet.ShowModal;
  { TODO -oHerb -cSACC : free form after use for SACC from Brian }
  patGet.Free;
end;

procedure TfrmMain.trvNotesChanging(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
var
  ntNote: TNoteRecord;
begin
  //Get the last node
  if assigned(trvNotes.Selected) then
  begin
        //Save this note
    ntNote := trvNotes.Selected.Data;
        //Have one?
    if assigned(ntNote) then
      SaveNote(ntNote);
  end
end;

procedure TfrmMain.GetWindowPos();
var
  reg: TRegistry;
  iState, iLeft, iTop, iWidth, iHeight, iNTWidth, iTHeight: integer;
begin
  //Default
  reg := nil;
  iState := 0; iLeft := Self.Left; iTop := Self.Top; iWidth := Self.Width; iHeight := Self.Height;
  iNTWidth := pnlNoteTempSel.Width; iTHeight := pnlTemplates.Height;

  //Retrieve our size information
    { TODO -oHerb -cSACC : Move TRegistry.Create out of try/final block - SACC from Brian }
  reg := TRegistry.Create();
  try // begin try/finally block to free reg
    try // begin try/finally block to register data
      try // begin try/except block to register data
  //      reg := TRegistry.Create();
        reg.RootKey := HKEY_CURRENT_USER;
          { TODO -oHerb -cSACC : Registry location changed to Vista for SACC from Joel }
//        if reg.OpenKey('\Software\Department of Veterans Affairs\MEDNotes\', True) then
        if reg.OpenKey('\Software\VISTA\MEDNotes\', True) then
        begin
              //Get the window state

          iState := reg.ReadInteger('state');
              //Maximized?
          if iState <> 1 then
          begin
                //No.  Get our other settings.  Otherwise we use the defaults
            iLeft := reg.ReadInteger('left');
            iTop := reg.ReadInteger('top');
            iWidth := reg.ReadInteger('width');
            iHeight := reg.ReadInteger('height');
          end; // end if IState
              //Split panel widths
              //Note/Template
          iNTWidth := reg.ReadInteger('note_temp_width');
              //Template
          iTHeight := reg.ReadInteger('temp_height');
        end; // end if reg.OpenKey
      except
        on E: Exception do
        begin
              //Default value of no action
          iState := -2;
          Application.HandleException(Self);
        end; // end on E:Excpetion
      end; // end try/except block to register data
    finally
        { TODO -oHerb -cSACC : Move TRegistry.Create out of try/final block - SACC from Brian }
//        if assigned(reg) then
//        begin
      reg.CloseKey;
//          reg.Free;
    end; // end try/finally block to register data
  finally
    FreeAndNil(reg);
  end; // end try/finally block to free reg

  //Apply our settings?
  if iState = -1 then Exit;

  //Position
  Self.Left := iLeft;
  Self.Top := iTop;
  Self.Width := iWidth;
  Self.Height := iHeight;

  //Panels
  pnlNoteTempSel.Width := iNTWidth;
  pnlTemplates.Height := iTHeight;


  //Window State
  case iState of
    -1: Self.WindowState := wsMinimized;
    0: Self.WindowState := wsNormal;
    1: Self.WindowState := wsMaximized;
  end;

end;


procedure TfrmMain.SaveWindowPos();
var
  reg: TRegistry;
  iState: integer;
begin
  //Minimized?
  if Self.WindowState = wsMinimized then
    Exit;

  //Get our windowstate to store it
  case Self.WindowState of
    wsNormal: iState := 0;
    wsMaximized: iState := 1;
  else
    iState := 0;
  end;

  //Save our size information
    { TODO -oHerb -cSACC : Move TRegistry.Create out of try/final block - SACC from Brian }
  reg := TRegistry.Create();
  try
//      reg := TRegistry.Create();
    reg.RootKey := HKEY_CURRENT_USER;
      { TODO -oHerb -cSACC : Registry location changed to Vista for SACC from Joel }
//      if reg.OpenKey('\Software\Department of Veterans Affairs\MEDNotes\', True) then
    if reg.OpenKey('\Software\VISTA\MEDNotes\', True) then
    begin
          //State
      reg.WriteInteger('state', iState);
          //Left
      reg.WriteInteger('left', Self.Left);
          //Top
      reg.WriteInteger('top', Self.Top);
          //Width
      reg.WriteInteger('width', Self.Width);
          //Height
      reg.WriteInteger('height', Self.Height);
          //NoteTemplate Width
      reg.WriteInteger('note_temp_width', pnlNoteTempSel.Width);
          //Templates Height
      reg.WriteInteger('temp_height', pnlTemplates.Height);
    end;
  finally
    if assigned(reg) then
    begin
      reg.CloseKey;
      reg.Free;
    end;
  end;

end;

procedure TfrmMain.cmbFindChange(Sender: TObject);
var
  fndItem: TFindItem;
  strFind: string;
  lastKey: integer;
  keyIndex: integer;
begin
  //Do our autocomplete
    //String to find a match for
  strFind := cmbFind.Text;
    //Get the last key
  lastKey := cmbFind.Tag;

    //Backspace/delete?
  if (lastKey = 8) or (lastKey = VK_DELETE) then
  begin
    lastKey := 0;
    cmbFind.Tag := lastKey;
    Exit;
  end;

    //Have a key index?
  keyIndex := cmbFind.Perform(CB_FINDSTRING, wParam(-1), (LPARAM(strFind)));
  if keyIndex > -1 then
  begin
          //Set this as the item
    cmbFind.ItemIndex := keyIndex;
          //Set the selection
    cmbFind.SelStart := Length(strFind);
    cmbFind.SelLength := Length(cmbFind.Text) - Length(strFind); //select the appropriate text
  end;

  //Show our item
  if cmbFind.ItemIndex > -1 then
  begin
      //Get the Find Item
    fndItem := TFindItem(cmbFind.Items.Objects[cmbFind.ItemIndex]);
      //Have one?
    if assigned(fndItem) then
    begin
          //Undo any current selection
      memPatSummary.SelLength := 0;
          //Move to the last line so our found item is always at the top if possible
      memPatSummary.SelStart := SendMessageW(memPatSummary.Handle, EM_LINEINDEX, memPatSummary.Lines.Count, 0);
      SendMessageW(memPatSummary.Handle, EM_SCROLLCARET, 0, 0);
          //Now Find our item
      memPatSummary.SelStart := SendMessageW(memPatSummary.Handle, EM_LINEINDEX, fndItem.Line, 0);
      SendMessageW(memPatSummary.Handle, EM_SCROLLCARET, 0, 0);
    end;
  end;
end;

procedure TfrmMain.cmbFindKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  cmbFind.Tag := Key;
end;

procedure TfrmMain.actFindUpdate(Sender: TObject);
begin
  //Is the active control a memo field?
  if (Self.ActiveControl is TMemo) or (Self.ActiveControl is TRichEdit) then
    actFind.Enabled := True
  else
    actFind.Enabled := False;
end;

procedure TfrmMain.actFindExecute(Sender: TObject);
begin
  fLastSearchPOS := -1;

  //Valid control?
  if ActiveControl is TMemo then
    with ActiveControl as TMemo do
    begin
      HideSelection := False;

        //Reset the selection
      SelStart := 0;
      SelLength := 0;

        //Execute
      fndDlg.Execute();
    end;

  if Self.ActiveControl is TRichEdit then
    with ActiveControl as TRichEdit do
    begin
      HideSelection := False;

      //Reset the selection
      SelStart := 0;
      SelLength := 0;

      //Execute
      fnddlg.Execute();
    end;
end;

procedure TfrmMain.fndDlgFind(Sender: TObject);
var
  iSearch: integer;
  strSearch: string;
  iStart, aFoundPOS: integer;
  aRichEdt: TRichEdit;
begin
  // Valid control?
  if ActiveControl is TMemo then
    with ActiveControl as TMemo do
    begin
           // Get out text to search
      iStart := SelStart + SelLength;
      strSearch := LowerCase(copy(Text, iStart + 1, Length(Text)));
      iSearch := Pos(LowerCase(fndDlg.FindText), strSearch);
      if iSearch > 0 then
      begin
        SelStart := iStart + iSearch - 1;
        SelLength := Length(fndDlg.FindText);
      end;

      if iSearch = 0 then
        MessageBox( self.Handle, PChar('No matches found'), 'No matches found', MB_ICONINFORMATION or MB_OK);
    end;

  if ActiveControl is TRichEdit then
  begin
    aRichEdt := (ActiveControl as TRichEdit);
    aFoundPOS := aRichEdt.FindText(fndDlg.FindText, fLastSearchPOS + 1, Length(aRichEdt.Text), []);
    if aFoundPOS > -1 then
    begin
      aRichEdt.SelStart := aFoundPOS;
      aRichEdt.SelLength := Length(fndDlg.FindText);
      fLastSearchPOS := aFoundPOS;
    end else begin
      if fLastSearchPOS > -1 then
      begin
        fLastSearchPOS := -1;
        fndDlgFind(Self);
      end else
         MessageBox( self.Handle, PChar('No matches found'), 'No matches found', MB_ICONINFORMATION or MB_OK);
    end;
  end;
end;

procedure TfrmMain.fndDlgClose(Sender: TObject);
var
  memFind: TMemo;
  iStart: integer;
  iLen: integer;
begin
  //Valid control?
  if not (Self.ActiveControl is TMemo) then Exit;
  //Set it
  memFind := TMemo(Self.ActiveControl);
  //Get our selection
  iStart := memFind.SelStart;
  iLen := memFind.SelLength;
  //Restore hiding the Selection
  memFind.HideSelection := True;
  //Set the selection
  memFind.SelStart := iStart;
  memFind.SelLength := iLen;
end;

procedure TfrmMain.actPrintExecute(Sender: TObject);
var
  frmPrint: TfrmPrint;
begin
  //Show the print form
  frmPrint := TfrmPrint.Create(Self);
  frmPrint.ShowModal;

  //Done
  frmPrint.Release;

end;

procedure TfrmMain.FormResize(Sender: TObject);
begin
  //Can we resize anything?
  if Self.WindowState = wsMinimized then Exit;

  //Resize?
  if (trvNotes.Height + spltHorNotesTempl.Height + pnlTemplates.Height) > pnlNoteTempSel.Height then
  begin
        //Resize our notes
    trvNotes.Height := spltHorNotesTempl.MinSize;
        //And our templates
    pnlTemplates.Height := pnlNoteTempSel.Height - spltHorNotesTempl.Height - trvNotes.Height;
  end;

  if (pnlNoteTempSel.Width + pnlNote.Width + spltVertTempNote.Width) > tabNotes.Width then
  begin
        //Resize our Template/Notes panel
    pnlNoteTempSel.Width := spltVertTempNote.MinSize;
        //And our note
    pnlNote.Width := tabNotes.Width - spltVertTempNote.Width - pnlNoteTempSel.Width;
  end;
end;

procedure TfrmMain.mnuContentsClick(Sender: TObject);
begin
  //Show our Main help
  Application.HelpFile := ExtractFilePath(Application.ExeName) + 'MED.chm';
  HtmlHelp(0, Application.HelpFile, HH_DISPLAY_TOC, 0);

end;

procedure TfrmMain.btnCreateNoteClick(Sender: TObject);
var
  strItem, strNote: string;
  ntNewNote: TNoteRecord;
  ndPend: TTreeNode;
begin
  //Have a selected note?
  if lstTemplates.ItemIndex < 0 then Exit; //No.

  //Open the specified note
  strItem := lstTemplates.Items[lstTemplates.ItemIndex];

  //None found item?
  if not (strItem = 'No Templates Found') then
  begin
      //Load it
    strNote := RenderTemplate(GetTemplateXML(strItem));
      //Clear current
    ntCurr := nil;
      //Now create our note
    ntNewNote := TNoteRecord.Create(CurrPatient);
    ntNewNote.ParentDFN := CurrPatient.DFN;
    ntNewNote.Saved := False;
    ntNewNote.Text := strNote;
    ntNewNote.Caption := FormatDateTime('mmm dd,yy', Now) + ' ' + strItem;
    ntNewNote.Title := strItem;
      //Create our tree view item
    ndPend := trvNotes.Items.AddChild(pendingNode, ntNewNote.Caption);
      //Assign this to our note
    ntNewNote.Data := ndPend;
      //Set this note to the node
    ndPend.Data := ntNewNote;
      //Change
    ndPend.Selected := true;
      //Set this as our current
    ntCurr := ntNewNote;
      //Expand this node
    PendingNode.Expand(True);
  end;
end;

procedure TfrmMain.lstTemplatesDblClick(Sender: TObject);
begin
  //Create the note
  btnCreateNoteClick(btnCreateNote);
end;

procedure TfrmMain.lstTemplatesClick(Sender: TObject);
begin
  //Have an item?
  if lstTemplates.ItemIndex >= 0 then
    btnCreateNote.Enabled := True
  else
    btnCreateNote.Enabled := False;
end;

procedure TfrmMain.actRetPatListExecute(Sender: TObject);
begin
  //Get the patient list
  GetPatList();
end;

procedure TfrmMain.actRetPatListUpdate(Sender: TObject);
begin
  //Can this option be run?
  actRetPatList.Enabled := not blnGettingPatList;
end;

procedure TfrmMain.actSaveNoteExecute(Sender: TObject);
begin
  //Add note save ability to menu.  *SMT*
  if assigned(ntCurr) then SaveNote(ntCurr);
end;

procedure TfrmMain.actSaveNoteUpdate(Sender: TObject);
begin
  //Can we save a note?    *SMT*
  if assigned(ntCurr) then
    actSaveNote.Enabled := True
  else
    actSaveNote.Enabled := False;
end;

procedure TfrmMain.mnuCompactDBClick(Sender: TObject);
begin
  //Make sure they want to do this
    { TODO -oHerb -c508 : MessageDlg NOT speaking the text.  Trying GetScreenReader.Speak.
If this is not satisfactory maybe create a seperate Form with buttons. }
  GetScreenReader.Speak('This will close MED including any open Notes.  Are you sure you want to do this?');

    { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian }
  if // MessageDlg('This will close MED including any open Notes.  Are you sure you want to do this?',mtWarning,[mbYes, mbNo],0)
    { TODO -oHerb -cMake MessageBox Modal : 2/27/2010 Need to make MessageBox Modal to owner. }
//    MessageBox(Handle, PChar('This will close MED including any open Notes.  Are you sure you want to do this?'),
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmMain.Handle, PChar('This will close MED including any open Notes.  Are you sure you want to do this?'),
    MessageBox( self.Handle, PChar('This will close MED including any open Notes.  Are you sure you want to do this?'),
    'Warning - Database closing', MB_ICONWARNING or MB_YESNO) = mrYes then

  begin
        //Cleanup
    Finish;
        //Quit
    QuitApp(True);
  end;
end;

procedure TfrmMain.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
  if Msg.message = PrevInstMsg then
  begin
      //Bring to the front.
    Application.Restore;
    SetForeGroundWindow(Application.MainForm.Handle);
    Handled := true;
  end;
end;

procedure TfrmMain.ManageSettings();
var
  umManage: TfrmMedSettings;
begin
    { TODO -oherb -c508 : Add Try/Finally block - per Brian }
  //Show the User Management Dialog
  umManage := TfrmMedSettings.Create(Self);
  try
    umManage.ShowModal;
    SetSaveInterval(SaveInterval);
  finally
    umManage.Release;
  end;
end;

procedure TfrmMain.mnuManageSettingsClick(Sender: TObject);
begin
  //Show the User Management Dialog
  ManageSettings();
end;

procedure TfrmMain.memNoteProtectChange(Sender: TObject; StartPos,
  EndPos: Integer; var AllowChange: Boolean);
begin
  AllowChange := blnCanChangeProtected;
end;

procedure TfrmMain.memNoteKeyPress(Sender: TObject; var Key: Char);
begin
  //Pipe character?
  if Key = #124 then
    Key := #0; //Yes.  We reserve this character for use as a Data Object marker so don't allow it.
end;

procedure TfrmMain.ScratchPadClick(Sender: TObject);
var
  { TODO -oherb -c508 : Replace TToolBar and TToolButton with TPanel and TButton }
//  btnClicked:TToolButton;
  btnClicked: TButton;
  strScratch: string;
begin
//  if Sender is TToolButton then
  if Sender is TButton then
  begin
//      btnClicked := TToolButton(Sender);
    btnClicked := TButton(Sender);
    strScratch := RenderTemplate(GetTemplateXML(btnClicked.Hint));
      //Append at the end
    memScratch.Lines.Add(CRLF + CRLF + '-' + btnClicked.Hint + '  ' + DateToStr(Now) + '--------------------------------------' + CRLF + strScratch);
  end;
end;

procedure TfrmMain.MEDExc(Sender: TObject; E: Exception);
var
//  logFile:TextFile;
  logFile: TStringList;
begin
  //Log the error
//    try
      //Exist?
//        AssignFile(logFile, 'med.err');
//        if not FileExists('med.err') then
//          Rewrite(logFile)    //Create the file
//        else
//          Append(logFile);    //Append to the current file
      //Write our error message
//        Writeln(logFile,'Error:' + DateToStr(Date) + ' ' + TimeToStr(Now) + ' ' + E.Message + CRLF + '     Critical:' + CriticalErr);
      //Close the file
//        Flush(logFile);
//        CloseFile(logFile);
//    except
//    end;

    { TODO -oherb -cSACC : CloseFile should be inside a try/finally block, Brian recommend this: }

  LogFile := TStringList.Create;
  try
    if FileExists(IncludeTrailingPathDelimiter(AppDataPath) + 'med.err') then
      LogFile.LoadFromFile(IncludeTrailingPathDelimiter(AppDataPath) + 'med.err');
    LogFile.Text := LogFile.Text + CRLF + 'Error:' + DateToStr(Date) + ' ' +
      TimeToStr(Now) + ' ' + E.Message + CRLF +
      '     Critical:' + CriticalErr;
    LogFile.SaveToFile(IncludeTrailingPathDelimiter(AppDataPath) + 'med.err');
  finally
    FreeAndNil(logFile);
  end;

end;

procedure TfrmMain.trvNotesMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  //Right click?
  if Button = mbRight then
  begin
        //Have a node?
    if assigned(trvNotes.GetNodeAt(X, Y)) then
    begin
              //Select the Node
      trvNotes.Selected := trvNotes.GetNodeAt(X, Y);
              //Have a note?
      if assigned(trvNotes.Selected.Data) then
      begin
                    //Yes. Do the popup menu (We do this here instead of the PopupMenu property to ensure that "right" click selects the node)
        popAction.Popup(Mouse.CursorPos.x, Mouse.CursorPos.y);
      end;
    end;
  end;
end;

procedure TfrmMain.CopyTemplatesFrom(Path: string);
var
  checkPath: string;
  sr: TSearchRec;
  { TODO -oShawn -cEnhancement : Code added to delete templates marked for deletion }
  delFile:string;

begin
  //Create our check path
  checkPath := Path;
  //Have a trailing slash?
  if Copy(checkPath, Length(checkPath), 1) <> '\' then
  begin
    checkPath := checkPath + '\';
  end;

  //Check the specified path for templates and copy them down to this client
  try
    if FindFirst(checkPath + '*.txml', faAnyFile, sr) = 0 then
    begin
        //Copy this file
      CopyFile(PChar(checkPath + sr.Name), PChar(AppDataPath + '\Templates\' + sr.Name), False);

      while FindNext(sr) = 0 do
      begin
          //Copy this file
        CopyFile(PChar(checkPath + sr.Name), PChar(AppDataPath + '\Templates\' + sr.Name), False);
      end;
    end;
  except
    on E: exception do
    begin
          //Show that there was an error.
      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message);
      { TODO -oHerb -cMake MessageBox Modal : 2/27/2010 Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message), 'Error', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmMain.Handle, PChar('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message), 'Error', MB_OK);
      MessageBox( self.Handle, PChar('Error copying templates from "' + checkPath + '" to "' + AppDataPath + '\Templates\" : ' + E.Message), 'Error', MB_OK);
      Application.HandleException(nil);
    end;
  end;

  { TODO -oShawn -cEnhancement : Code added to delete templates marked for deletion }
    //Check the specified path for delete templates and delete them from this client
    try
        if FindFirst(checkPath + '*.delete', faAnyFile, sr) = 0 then
                begin
                        //Get the txml version of the file name
                        delFile := StringReplace(sr.Name,'.delete','.txml',[rfIgnoreCase]);

                        //Delete the file
                        DeleteFile(PChar(AppDataPath + '\Templates\' + delFile));

                        while FindNext(sr) = 0 do
			        begin
                                //Get the txml version of the file name
                                delFile := StringReplace(sr.Name,'.delete','.txml',[rfIgnoreCase]);

                                //Copy this file
                                DeleteFile(PChar(AppDataPath + '\Templates\' + delFile));
				end;
			end;
    except
      on E:exception do
        begin
          //Show that there was an error.

      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message);
      { TODO -oHerb -cMake MessageBox Modal : 2/27/2010 Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message), 'Error', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmMain.Handle, PChar('Error copying templates from "' + checkPath + '" to "' + GetCurrentDir + '\Templates\" : ' + E.Message), 'Error', MB_OK);
      MessageBox( self.Handle, PChar('Error copying templates from "' + checkPath + '" to "' + AppDataPath + '\Templates\" : ' + E.Message), 'Error', MB_OK);

            Application.HandleException(nil);
        end;
    end;


    { TODO -oherb -cSACC : FindClose() must be used with FindFirst() - per Brian }
  FindClose(sr);
  //Finished
end;

procedure TfrmMain.mnuViewScratchTabClick(Sender: TObject);
begin
  //Change to the scratch pad tab
  pgTabs.ActivePage := tabScratch;
  pgTabsChange(Sender);
end;

procedure TfrmMain.memScratchChange(Sender: TObject);
begin
  //Do we have a note item?
  if assigned(CurrPatient) and (memScratch.Tag <> 1) then
  begin
    CurrPatient.ScratchPad := memScratch.Text;
    CurrPatient.NeedSave := True;
  end;
end;


procedure TfrmMain.memScratchEnter(Sender: TObject);
begin
          { TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }
          // is this going to work?????    no - try saying it.
//  VA508CompAccScratchPad.Caption := 'Scratch Pad for ' +
//    stPatName.Caption + 'SSN' + stPatSSN.Caption + 'DOB' + stPatDOB.Caption;
  GetScreenReader.Speak( 'Scratch Pad for ' + stPatName.Caption + 'SSN' + stPatSSN.Caption + 'DOB' + stPatDOB.Caption);
end;

procedure TfrmMain.SetSaveInterval(Secs :Integer);
begin
  tmrSave.Interval := Secs * 1000;
end;

procedure TfrmMain.UMInitiate(var Message: TMessage);
begin
  //Show our patient select dialog
  SelectPat();
end;


end.
