unit fMedSettings;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, uDB, uCore, ComCtrls, shlobj, ShellAPI, VA508AccessibilityManager;

type
  TfrmMedSettings = class(TForm)
    btnClose: TButton;
    TabPages: TPageControl;
    tbshtDataFiles: TTabSheet;
    tbshtDatabase: TTabSheet;
    edtSuggestCompactAfter: TEdit;
    lblSuggestCompactAfter: TLabel;
    chkSuggestCompact: TCheckBox;
    lblTemplatePath: TLabel;
    edtTemplateUpdatePath: TEdit;
    { TODO -oHerb -c508 :
... was showing up in Jaws as ... => changed the arrangement and
caption to 'Browse' }
    btnTemplateBrowse: TButton;
    chkRetrieveHS: TCheckBox;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    VA508CompAccBtnTemplateBrowse: TVA508ComponentAccessibility;
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnTemplateBrowseClick(Sender: TObject);
    procedure edtSuggestCompactAfterKeyPress(Sender: TObject;
      var Key: Char);
    procedure tbshtDataFilesShow(Sender: TObject);
    procedure tbshtDatabaseShow(Sender: TObject);
  public
    { Public declarations }
  end;

function BrowseForFolderCallBack(Wnd: HWND; uMsg: UINT; lParam, lpData: LPARAM): Integer stdcall;

var
  frmUserManage: TfrmMedSettings;
  defDir: string;

implementation

{$R *.DFM}
uses
  VA508AccessibilityRouter;

procedure TfrmMedSettings.btnCloseClick(Sender: TObject);
begin
  //Close this form
  Self.Close;
end;

procedure TfrmMedSettings.FormCreate(Sender: TObject);
begin
  //Update our UI with our settings
  { TODO -oHerb -cSACC : changed txt prefix to edt }
  edtTemplateUpdatePath.text := TemplateUpdatePath;
  chkRetrieveHS.Checked := RetrieveHS;
  edtSuggestCompactAfter.text := IntToStr(CompactAtSize);
  chkSuggestCompact.Checked := SuggestCompact;
end;

procedure TfrmMedSettings.tbshtDataFilesShow(Sender: TObject);
begin
  { TODO -oHerb -c508 : Adding JAWS action because setting the hint did not work }
  GetScreenReader.Speak('Settings page');
end;

procedure TfrmMedSettings.tbshtDatabaseShow(Sender: TObject);
begin
  { TODO -oHerb -c508 : Adding JAWS action because setting the hint did not work }
  GetScreenReader.Speak('Database page');
end;

procedure TfrmMedSettings.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //Apply settings
  { TODO -oHerb -cSACC : changed txt prefix to edt }
  TemplateUpdatePath := edtTemplateUpdatePath.text;
  RetrieveHS := chkRetrieveHS.Checked;
  CompactAtSize := StrToInt(edtSuggestCompactAfter.text);
  SuggestCompact := chkSuggestCompact.Checked;
  //Save the settings
  SaveSettings();
end;

procedure TfrmMedSettings.btnTemplateBrowseClick(Sender: TObject);
var
  bri: TBrowseInfo;
  folder: array[0..MAX_PATH] of char;
  idList: PItemIDList;
begin
  //Set the current
  { TODO -oHerb -cSACC : changed txt prefix to edt }
  defDir := edtTemplateUpdatePath.Text;

  //Zeroize our struct
  FillChar(bri, SizeOf(bri), #0);
  //Set our values
  bri.pszDisplayName := @folder[0];
  bri.lpszTitle := PChar('Select Template Update Folder');
  bri.ulFlags := BIF_RETURNONLYFSDIRS;
  bri.hwndOwner := Application.Handle;
  //Callback?
  if defDir <> '' then
    bri.lpfn := BrowseForFolderCallBack; //Yes.

  //Search
  idList := SHBrowseForFolder(bri);

  //Have anything?
  if Assigned(idList) then
  begin
        //Yes.  Get the folder
        { TODO -oHerb -cSACC : changed txt prefix to edt }
    if SHGetPathFromIDList(idList, folder) then
      edtTemplateUpdatePath.Text := folder;
        //Release
    GlobalFreePtr(idList);
  end;


end;

function BrowseForFolderCallBack(Wnd: HWND; uMsg: UINT; lParam, lpData: LPARAM): Integer stdcall;
begin
  //Inited?
  if uMsg = BFFM_INITIALIZED then
    SendMessage(Wnd, BFFM_SETSELECTION, 1, Integer(@defDir[1])); //Send the pointer to the string referencing our default directory to show
  //Ret
  result := 0;
end;


procedure TfrmMedSettings.edtSuggestCompactAfterKeyPress(Sender: TObject;
  var Key: Char);
var
  keyCode: integer;
begin
  keyCode := Ord(Key);
  //Acceptable range?
  if (keyCode <> 8) and (keyCode <> 13) and (IsNumeric(Key) = False) then
    Key := Chr(0); //Don't allow this key
end;

end.
