unit fPrint;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, uPatient, printers, uCore, uTextPrinter, CheckLst, comctrls, uNote, {*reenable:hh_funcs,*} uDB,
  VA508AccessibilityManager;

type
  TTextPrintID = class(TObject)
  public
    PrintType: string;
    PrintID: string;
    constructor Create(PType, PID: string);
  end;

  TfrmPrint = class(TForm)
    btnPrint: TButton;
    prntDlg: TPrintDialog;
    clstDocs: TCheckListBox;
    btnCancel: TButton;
    lblDocs: TLabel;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    procedure btnPrintClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure clstDocsClick(Sender: TObject);
    procedure clstDocsKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    function PrintReport(PrintWhat: TTextPrintID; pr: TPrinter; Count: integer): boolean;
    function PrintHealthSummary(patHS: TPatRecord; pr: TPrinter; Count: integer): boolean;
    function PrintNote(patHS: TPatRecord; ntPr: TNoteRecord; pr: TPrinter; Count: integer): boolean;

     { TODO -oHerb -cModification : Add Scratchpad to be printed }
    function PrintScratchpad(patHS: TPatRecord; pr: TPrinter; Count: integer): boolean;

    procedure VerifyPrint();
  public
    { Public declarations }
  end;

var
  frmPrint: TfrmPrint;

implementation

uses fMED;

{$R *.DFM}

procedure TfrmPrint.btnPrintClick(Sender: TObject);
var
  selItem: TObject;
  i, ct: integer;
begin
  //Launch our Print Dialog.
  if prntDlg.Execute then
  begin
        //Get the count
    ct := prntDlg.Copies;
    if ct < 1 then ct := 1;
        //Get each item
    for i := 0 to clstDocs.Items.Count - 1 do
    begin
              //Checked?
      if clstDocs.Checked[i] then
      begin
                    //Get the item if any
        selItem := clstDocs.Items.Objects[i];
                    //Have one?
        if selItem is TTextPrintID then
        begin
                          //Determine what to print
          if TTextPrintID(selItem).PrintType = 'HealthSumm' then
          begin
                                //No.  Health summary or report
            if not PrintHealthSummary(CurrPatient, Printer, ct) then
            begin
                                      //Failed
              { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//              MessageBox(Self.Handle, PChar('Error printing the Health Summary for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//              MessageBox( frmPrint.Handle, PChar('Error printing the Health Summary for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
              MessageBox( self.Handle, PChar('Error printing the Health Summary for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
              Printer.Abort;
              Exit;
            end;
          end


          { TODO -oHerb -cModification : Add Scratchpad to be printed }
           else  if TTextPrintID(selItem).PrintType = 'Scratchpad' then
             begin

//              if TTextPrintID(selItem).PrintType = 'Scratchpad' then
//                begin
                                //No.  Health summary or report
               if not PrintScratchpad(CurrPatient, Printer, ct) then
                 begin
                                 //Failed
                   { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//                   MessageBox(Self.Handle, PChar('Error printing the Scratchpad for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//                   MessageBox( frmPrint.Handle, PChar('Error printing the Scratchpad for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
                   MessageBox( self.Handle, PChar('Error printing the Scratchpad for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
                   Printer.Abort;
                   Exit;
                 end;
             end





          else
          begin
            if not PrintReport(TTextPrintID(selItem), Printer, ct) then
            begin
                                    //Failed
              { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//              MessageBox(Self.Handle, PChar('Error printing the ' + TTextPrintID(selItem).PrintID + ' report'), 'Error Printing', MB_OK + MB_ICONWARNING);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//              MessageBox( frmPrint.Handle, PChar('Error printing the ' + TTextPrintID(selItem).PrintID + ' report'), 'Error Printing', MB_OK + MB_ICONWARNING);
              MessageBox( self.Handle, PChar('Error printing the ' + TTextPrintID(selItem).PrintID + ' report'), 'Error Printing', MB_OK + MB_ICONWARNING);
              Printer.Abort;
              Exit;
            end;
          end;
        end
        else if selItem is TNoteRecord then
        begin
                          //Print the total number of copies
                            //Yes.  Print the note
          if not PrintNote(CurrPatient, TNoteRecord(selItem), Printer, ct) then
          begin
                                  //Failed
            { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//            MessageBox(Self.Handle, PChar('Error printing the Note ''' + TNoteRecord(selItem).Caption + ''' for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//            MessageBox( frmPrint.Handle, PChar('Error printing the Note ''' + TNoteRecord(selItem).Caption + ''' for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
            MessageBox( self.Handle, PChar('Error printing the Note ''' + TNoteRecord(selItem).Caption + ''' for ' + CurrPatient.Name), 'Error Printing', MB_OK + MB_ICONWARNING);
            Printer.Abort;
            Exit;
          end;
        end;
      end;
    end;

        //Done
    Self.Close;
  end;
end;

function TfrmPrint.PrintReport(PrintWhat: TTextPrintID; pr: TPrinter; Count: integer): boolean;
var
  prText: TTextPrinter;
begin
  //Default value
  Result := False;
  //Ensure we have a PrintID item
  if not assigned(PrintWhat) then Exit;

  //Create our printer
  prText := TTextPrinter.Create();

  { TODO -oHerb -cSACC : prText need to be in a Try/Finally block per Brian }
  try
    //Set the Title, Header and Document
    prText.Title := PrintWhat.PrintID;

    //Now get the contents based on the Type
    if PrintWhat.PrintType = 'report_patientswithnote' then
    begin
            //Modify the Header
      prText.Header := PrintWhat.PrintID + #13 + 'Page &p of &P' + #13 + 'Patient' + StringOfChar(' ', 18) + 'Imported?' + StringOfChar(' ', 16) + 'Note';
            //Get the Patients/Notes
      prText.Document := GetPatientsAndNotesSummary();

            //Have it Print our total number of times
      Result := prText.Print(pr, frmMain.memPatSummary.Font, True, Count);
    end
    else
      Result := False; //No such report
  finally
      //Cleanup
    prText.Free;
  end;
end;

function TfrmPrint.PrintHealthSummary(patHS: TPatRecord; pr: TPrinter; Count: integer): boolean;
var
  prText: TTextPrinter;
begin
  //Default value
  Result := False;
  //Ensure we have a patient
  if not assigned(patHS) then Exit;

  //Create our printer
  prText := TTextPrinter.Create();

    { TODO -oHerb -cSACC : prText need to be in a Try/Finally block per Brian }
  try

    //Set the Title, Header and Document
    prText.Title := 'Health Summary and Note for ' + CurrPatient.Name;
    prText.Header := 'Health Summary for ' + CurrPatient.Name + #13 + 'Page &p of &P';
    prText.Document := frmMain.memPatSummary.Text;

    //Have it Print our total number of times
    Result := prText.Print(pr, frmMain.memPatSummary.Font, True, Count);
  finally
    //Cleanup
    prText.Free;
  end;
end;




function TfrmPrint.PrintScratchpad(patHS: TPatRecord; pr: TPrinter; Count: integer): boolean;
var
  prText: TTextPrinter;
begin
  //Default value
  Result := False;
  //Ensure we have a patient
  if not assigned(patHS) then Exit;

  //Create our printer
  prText := TTextPrinter.Create();

    { TODO -oHerb -cSACC : prText need to be in a Try/Finally block per Brian }
  try

    //Set the Title, Header and Document
    prText.Title := 'Scratchpad for ' + CurrPatient.Name;
    prText.Header := 'Scratchpad for ' + CurrPatient.Name + #13 + 'Page &p of &P';
    prText.Document := frmMain.memScratch.Text;

    //Have it Print our total number of times
    Result := prText.Print(pr, frmMain.memPatSummary.Font, True, Count);
  finally
    //Cleanup
    prText.Free;
  end;
end;









procedure TfrmPrint.btnCancelClick(Sender: TObject);
begin
  //Close this form
  Self.Close;
end;

procedure TfrmPrint.FormCreate(Sender: TObject);
var
  ndItem: TTreeNode;
  ntItem: TNoteRecord;
  i: integer;
  iLast: integer;
begin
  //Add our Reports
  iLast := clstDocs.Items.Add('Report: Patients with Notes Report');
  clstDocs.Items.Objects[iLast] := TTextPrintID.Create('report_patientswithnote', 'Patients With Notes');

  //Add our health summary
  iLast := clstDocs.Items.Add('Health Summary for ' + CurrPatient.Name);
  clstDocs.Items.Objects[iLast] := TTextPrintID.Create('HealthSumm', 'health_summary');
  clstDocs.Checked[iLast] := True;

  { TODO -oHerb -cModification : Add Scratchpad to be printed }
  //Add our Scratchpad
  iLast := clstDocs.Items.Add('Scratchpad for ' + CurrPatient.Name);
  clstDocs.Items.Objects[iLast] := TTextPrintID.Create('Scratchpad', 'scratchpad');
  clstDocs.Checked[iLast] := True;





  //Now add our documents
  for i := 0 to frmMain.trvNotes.Items.Count - 1 do
  begin
        //Get the node
    ndItem := frmMain.trvNotes.Items[i];
    ntItem := ndItem.Data;
        //Have an item?
    if assigned(ntItem) then
    begin
              //Add it
      iLast := clstDocs.Items.Add('Note ' + ntItem.Caption);
      clstDocs.Items.Objects[iLast] := ntItem;
              //Same note?
      if frmMain.ntCurr = ntItem then
        clstDocs.Checked[iLast] := True; //Currently selected note
    end;
  end;
end;

function TfrmPrint.PrintNote(patHS: TPatRecord; ntPr: TNoteRecord; pr: TPrinter; Count: integer): boolean;
var
  prText: TTextPrinter;
begin
  //Default value
  Result := False;
  //Ensure we have a patient
  if not assigned(patHS) or not assigned(ntPr) then Exit;

  //Create our printer
  prText := TTextPrinter.Create();

    { TODO -oHerb -cSACC : prText need to be in a Try/Finally block per Brian }

  try

    //Set the Title, Header and Document
    prText.Title := 'Note ''' + ntPr.Caption + ''' for ' + CurrPatient.Name;
    prText.Header := CurrPatient.Name + ' ' + ntPr.Caption + #13 + 'Page &p of &P';
    prText.Document := ntPr.Text;

    //Have it Print our total number of times
    Result := prText.Print(pr, frmMain.memPatSummary.Font, True, Count);
  finally
    //Cleanup
    prText.Free;
  end;
end;

procedure TfrmPrint.clstDocsClick(Sender: TObject);
begin
  //Verify we can Print
  VerifyPrint;
end;

procedure TfrmPrint.VerifyPrint();
var
  i: integer;
begin
  //Have selected items?
  for i := 0 to clstDocs.Items.Count - 1 do
  begin
    if clstDocs.Checked[i] then
    begin
            //Enable
      btnPrint.Enabled := True;
            //Done
      Exit;
    end;
  end;

  //Nothing to Print
  btnPrint.Enabled := False;
end;

procedure TfrmPrint.clstDocsKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  //Verify we can print
  VerifyPrint();
end;

constructor TTextPrintID.Create(PType, PID: string);
begin
  Self.PrintType := PType;
  Self.PrintID := PID;
end;

procedure TfrmPrint.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Itm: TObject;
  i: integer;
begin
  //Clear our list of any TTextPrintID items
  for i := 0 to clstDocs.Items.Count - 1 do
  begin
    Itm := clstDocs.Items.Objects[i];
    if assigned(Itm) then
    begin
            //What type?
      if Itm is TTextPrintID then
      begin
        FreeAndNil(Itm);
      end;
    end;
  end;
end;

end.
