unit uCore;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses classes, ORFn, uPatient, Controls, comctrls, Windows, sysutils;

procedure QuitApp(CompactDB: boolean = False);
function SelectPatient(Parent: TComponent): integer;
procedure GetNameSocFormat(contents: string; out name: string; out soc: string);
procedure ShowStatus(Message: string);
function IsAlpha(test: string): boolean;
function FormatSSN(SSN: string): string;
function IsNumeric(test: string): boolean;
function TrimNonNumeric(TrimStr: string): string;
function CodeArrSet(Code: string; CodeArr, RepWith: array of string): string;
function AppdataPath: String;

const
  CRLF = #10#13;
  SELPAT_CANCELLED = 1;
  SELPAT_SELECTED = 2;
  SELPAT_GETPATS = 3;
  SELPAT_RESELECT = 4;
var
  PrevInstMsg: Cardinal;
  blnGettingPatList: boolean;
  CurrPatient: TPatRecord;
  PatSelStatus: integer;
  Server: string;
  Port: string;
  //flag for del:kData:TCryptoSess;
  CurrStatus: TStatusPanel;
  CurrStatusBar: TStatusBar;
  CriticalErr: string;
  blnManageSettings: boolean;
  blnIsDemo: boolean;
  TemplateUpdatePath: string;
  SuggestCompact: boolean;
  CompactAtSize: integer;
  SaveInterval: Integer;
  RetrieveHS: boolean;
  StopRunningApp: Boolean;

implementation

uses
  Forms, fPtSel, uDB, Dialogs, ufileUpdater;

Var
  fAppDataFolder: String;

{Global routines}

//Return the string associated with a code e.g. ['a','b','c'] with ['Alpha','Beta','Ceta']

function CodeArrSet(Code: string; CodeArr, RepWith: array of string): string;
var
  i: Integer;
begin
  for i := 0 to Length(CodeArr) - 1 do
  begin
      { TODO -oHerb -cSACC : Need to check the length of RepWith Array per Brian }
//      If Code = CodeArr[i] then
    if (Code = CodeArr[i]) and (i < Length(RepWith)) then
    begin
      Result := RepWith[i];
      Exit;
    end;
  end;

  Result := '';
end;

//Return a hash calculated for a username/password pair

function GetPassHash(User, Pass: string): string;
begin
  Result := '';
  {
  strErrCtx := 'uCore.GHP #1.01 - Start'; //Set our context
  Result := kData.HashString(PASS_HASH_PRE + LowerCase(User) + '_' + LowerCase(Pass) + PASS_HASH_POST);
  strErrCtx := 'uCore.GHP #1.02 - Done'; //Set our context
  }
end;

//Update the status

procedure ShowStatus(Message: string);
begin
  if assigned(CurrStatus) then
  begin
    CurrStatus.Text := Message;
    CurrStatusBar.Repaint;
  end;
end;
//Quit the application

procedure QuitApp(CompactDB: boolean = False);
begin
  DBClose(CompactDB);
  Application.Terminate;
end;

//Format the string to a SSN with dashes

function FormatSSN(SSN: string): string;
var
  i: integer;
  s1: string;
  s2: string;
  s3: string;
  char: integer;
begin
  //Default
  Result := '';
  //Look for an invalid char
  for i := 1 to Length(SSN) do
  begin
    char := Ord(SSN[i]);
    if ((char >= 48) and (char <= 57)) then
    begin
            //Add this to our SSN parts
      if Length(s1) < 3 then
        s1 := s1 + SSN[i]
      else if Length(s2) < 2 then
        s2 := s2 + SSN[i]
      else
        s3 := s3 + SSN[i];
    end;
  end;

  //Valid?
  if Length(s3) <> 4 then
    Result := SSN //Return what was sent
  else
    Result := s1 + '-' + s2 + '-' + s3;
end;

//Show the select patient dialog and return the selected patient

function SelectPatient(Parent: TComponent): integer;
var
  patSel: TfrmSelPatient;
  patList: TPatRecordArr;
begin
    //Change our icon
  Screen.Cursor := crHourGlass;
    //Create the form
  patSel := TfrmSelPatient.Create(Parent);
      { TODO -oHerb -cSACC : patSel need to be in a try/finally block per Brian }
  try
    patList := GetPatientsArr;
    patSel.SetPatList(patList);
        //Give it our patient list
    patSel.ShowModal();
        //Change our icon back
    Screen.Cursor := crDefault;
        //Return our status
    Result := PatSelStatus;
        //Done
  finally
    patSel.Release;
    ReleasePatList(patList, CurrPatient);
  end;
end;

{This is used to get the name/social of a valid NameSoc pair. e.g. E0033 would return
name=e
soc=0033
}

procedure GetNameSocFormat(contents: string; out name: string; out soc: string);
begin
  //Valid?
  if Length(contents) <> 5 then
  begin
    name := '';
    soc := '';
    Exit;
  end;

  //Get our piecees
  name := copy(contents, 1, 1);
  soc := copy(contents, 2, 4);

  //Valid?
  if IsAlpha(name) and IsNumeric(soc) then
    Exit
  else
    name := '';
  soc := '';
end;

function IsAlpha(test: string): boolean;
var i: integer;
begin
  //Default
  Result := False;
  //Look for an invalid char
  for i := 1 to Length(test) do
  begin
    if not CharInSet(test[i], ['A'..'Z', 'a'..'z']) then
      Exit;
  end;
  //Yes
  Result := True;
end;

function IsNumeric(test: string): boolean;
var i: integer;
begin
  //Default
  Result := False;
  //Numeric?
  if test = '' then Exit;
  //Look for an invalid char
  for i := 1 to Length(test) do
  begin
    if not CharInSet(test[i], ['0'..'9']) then
      Exit;
  end;
  //Yes
  Result := True;
end;

function TrimNonNumeric(TrimStr: string): string;
var
  i: integer;
  strRet: string;
begin
  //Default
  strRet := '';
  //Look for valid chars
  for i := 1 to Length(TrimStr) do
  begin
    if CharInSet(TrimStr[i], ['0'..'9']) then strRet := strRet + TrimStr[i];
  end;
  //Yes
  Result := strRet;
end;

function AppdataPath: String;
begin
 Result := fAppDataFolder;
end;

initialization
  //Ensure an empty string
  CriticalErr := '';
  StopRunningApp := UpdateFiles(fAppDataFolder);

finalization
{clean}
  { TODO -oHerb -cSACC : Need to free as well as nil opject per Brian }
  FreeAndNil(CurrPatient);
//    if assigned(CurrPatient) then
//      begin
//      CurrPatient := nil;
//      end;


end.
