unit uImporter;

{
   Package: TIU - TEXT INTEGRATION UTILITIES 
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation 
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run. 
         Includes Template routines from CPRS
}

interface

{$D+}

uses
  Windows,SysUtils,ComObj, ActiveX, MEDImport_TLB, StdVcl, CPRSChart_TLB, uDB,Dialogs,uNote, fSelectNote, hh_funcs;

type
  TImporter = class(TAutoObject, IImporter, ICPRSExtension)
  protected
    function Execute(const CPRSBroker: ICPRSBroker;
      const CPRSState: ICPRSState; const Param1, Param2,
      Param3: WideString; var Data1, Data2: WideString): WordBool;
      safecall;
    { Protected declarations }
  private
    con:OleVariant;
    function getDLLDir():string;
    function GetUserManualAccess(CPRSBroker: ICPRSBroker):Integer;
  end;


{ TODO -oHerb -cFix Error : Convert DFN from Integer to INT64 for large DFNs }
//function GetDataObjects(BoilerPlate: string;DFN:integer;CPRSBroker: ICPRSBroker):string;
function GetDataObjects(BoilerPlate: string;DFN:INT64;CPRSBroker: ICPRSBroker):string;
procedure MEDExc(Sender: TObject; E: Exception);

var
    dllDir:string;
    CriticalErr:string;
const
    CRLF = #10#13;

implementation

uses ComServ;

function TImporter.getDLLDir():string;
var
  szFileName:array [0..255] of char;
begin
  //Get the filename
    if (GetModuleFileName(hInstance,szFileName,255) = 0) then
      Result := ''
    else
      Result := ExtractFilePath(szFileName);
end;

procedure MEDExc(Sender: TObject; E: Exception);
var
  logFile:TextFile;
begin
  //Log the error
    try
      //Exist?
        AssignFile(logFile, dllDir + 'med.err');
        if not FileExists(dllDir + 'med.err') then
          Rewrite(logFile)    //Create the file
        else
          Append(logFile);    //Append to the current file
      //Write our error message
        Writeln(logFile,'Error:' + DateToStr(Date) + ' ' + TimeToStr(Now) + ' ' + E.Message + CRLF + '     Critical:' + CriticalErr);
      //Close the file
        Flush(logFile);
        CloseFile(logFile);
    except
    end;
end;

function TImporter.Execute(const CPRSBroker: ICPRSBroker;
  const CPRSState: ICPRSState; const Param1, Param2, Param3: WideString;
  var Data1, Data2: WideString): WordBool;
var
  patSel:TfrmSelectNote;
  blnDbgDB,blnDbgRPC:boolean;
  { TODO -oherb -cINT64 : Texas invalid integer 12/15/2009 - change integer to INT64 }
//  iAccess,iPat:Integer;
  iAccess : Integer;
  iPat:INT64;
begin
  //Default
    blnDbgDB := True;
    blnDbgRPC := True;
    iAccess := 0;
  //Everything ok?
    if CriticalErr <> '' then
      begin
        //Show the error
          { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//          ShowMessage('A critical error has been encountered. #1' + CRLF + CRLF + 'Error:' + CriticalErr);
          MessageBox(0, PChar('A critical error has been encountered. #1' + CRLF + CRLF + 'Error:' + CriticalErr), 'Error', MB_OK);
        //Quit
          Result := False;
        //Close the DB
          Exit;
      end;

  if LowerCase(Param3) = 'nodb' then
    begin
      blnDbgDB := False;
      Data1 := 'No Database';
    end;

  if LowerCase(Param3) = 'norpc' then
    begin
      blnDbgRPC := False;
      Data1 := 'No RPC';
    end;

  //Get our DLL directory
    dllDir := getDLLDir();
    
  //Testing?
    if LowerCase(Param3) = 'show info' then
      begin
        Data1 := '--MED Importer -------' + #10;
        Data1 := Data1 + 'Current Directory: ' + GetCurrentDir + #10;
        Data1 := Data1 + 'DLL Directory: ' + dllDir + #10;
        Data1 := Data1 + 'Passed values' + #10;
        Data1 := Data1 + '  Param 1: ' + Param1 + #10;
        Data1 := Data1 + '  Param 2: ' + Param2 + #10;
        Data1 := Data1 + '  Data 2: ' + Data2 + #10 + #10;
        Data1 := Data1 + 'For support contact' + #10;
        Data1 := Data1 + ' zzzzzzzzzuser' + #10;
        Data1 := Data1 + ' Alexandria VAMC; Alexandria, LA' + #10;
        Data1 := Data1 + ' (318)-473-0010' + #10;
        Data1 := Data1 + ' zzzzzzzzzuser@med.domain' + #10;
        Data1 := Data1 + '--END MED Importer ---' + #10;
        Result := true;
        Exit;
      end
    else
      findTitle := Param3;

  //Open the database
    if blnDbgDB = True then
      begin
        if not DBConnect(dllDir + 'db\MED.mdb',con) then
          begin
            { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- could not use Handle}
//            MessageDlg('Error opening the ''' + dllDir + 'db\MED.mdb'' database file',mtError,[mbOK],0);
            MessageBox(0, PChar('Error opening the ''' + dllDir + 'db\MED.mdb'' database file'), 'Database Error', MB_ICONERROR or MB_OK);
            Result := False;
            Exit;
          end;
      end;
     


  //Get patient information
    try
      if blnDbgRPC = True then
        begin
          //Set our context
          { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//          CPRSBroker.SetContext('ABQMED RPC');
          CPRSBroker.SetContext('TIU MED GUI RPC');
          //Get this user's information
          iAccess := GetUserManualAccess(CPRSBroker);
          //Look for matching patients. If no match is found the CPRS DFN is returned.
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//          iPat := GetPatient(con,StrToInt(CPRSState.PatientDFN),CPRSState.PatientName,CPRSState.PatientDOB,CPRSState.PatientSSN,iAccess);
          iPat := GetPatient(con,StrToInt64(CPRSState.PatientDFN),CPRSState.PatientName,CPRSState.PatientDOB,CPRSState.PatientSSN,iAccess);
        end;
    except on E:Exception do
      begin
        //Log the exception
          MEDExc(nil,E);        
        //Can't
          { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//          ShowMessage(E.Message);
          MessageBox(0, PChar(E.Message), 'Error', MB_OK);
          Result := False;
          Exit;
      end;
    end;

  //Ensure everything's ok
  //Everything ok?
    if CriticalErr <> '' then
      begin
        //Show the error
          { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//          ShowMessage('A critical error has been encountered. #2' + CRLF + CRLF + 'Error:' + CriticalErr);
          MessageBox(0, PChar('A critical error has been encountered. #2' + CRLF + CRLF + 'Error:' + CriticalErr), 'Error', MB_OK);
        //Quit
          Result := False;
        //Close the DB
          DBClose(con);
          Exit;
      end;

  //Get the notes for this patient
    try
      if blnDbgDB = True then
        begin
          //Get the array list
          arList := GetNotesArr(con,iPat);
        end;
    except
    end;

  //Have any notes?
    if blnDbgDB = True then
      begin
        if not assigned(arList) then
          begin
            DBClose(con);
            { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//            ShowMessage('There are no notes (Pending or Imported) for this patient in the MED database');
            MessageBox(0, PChar('There are no notes (Pending or Imported) for this patient in the MED database'), 'Error', MB_OK);
            Result := False;
            //FreeAndNil(kData);
            Exit;
          end;
      end;

     if blnDbgDB = True then
        begin

      //Catch any errors so we can close the DB
        try
          //Now let the user select which note to import
            patSel := TfrmSelectNote.Create(nil);
          //Show it
            patSel.ShowModal;
          //Release
            patSel.Release;
          //Return our data?
            if assigned(ntSelected) then
              begin
                //Return the dat with data objects added
                  if blnDbgRPC = True then
                    begin
                    
            { TODO -oHERB -cFIX : If manual entry (negative dfns in access database
                   then use the dfn that was found using the ssn lookup }
           if iPat < 0 then
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//             ntSelected.ParentDFN := StrToInt(CPRSState.PatientDFN);
             ntSelected.ParentDFN := StrToInt64(CPRSState.PatientDFN);
                    
                      Data1 := GetDataObjects(ntSelected.Text,ntSelected.ParentDFN,CPRSBroker);
                    end
                  else
                    begin
                      Data1 := ntSelected.Text;
                    end;
                  Result := True;
                //Flag this as imported
                  ntSelected.Imported := True;
                  ntSelected.SaveNote(con);
              end
            else
              begin
                Data1 := '';
                Result := False;
              end;
        except on E:Exception do
          begin
            //Log the error
              MEDExc(nil,E);
          end;
        end;

    end;

  //Release memory (no need to release pre or aft list since their objects are stored in this array)
    CleanNotesArr(arList);

  //Close the DB
    if blnDbgDB = True then
      begin
        DBClose(con);
      end;

  //Release our Cryptographic object
    //FreeAndNil(kData);
end;

{ TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }

{Determines what level of manual import this user has.
If the user holds the ABQMED MANUAL PATIENT key then they can import patients that perfectly match.
If the user holds the ABQMED MANUAL PATIENT OVERRIDE key then they can import patients with even less explicit information (e.g. By SSN Only) }

{Determines what level of manual import this user has.
If the user holds the TIU MED MANUAL PATIENT key then they can import patients that perfectly match.
If the user holds the TIU MED MANUAL OVERRIDE key then they can import patients with even less explicit information (e.g. By SSN Only) }


function TImporter.GetUserManualAccess(CPRSBroker: ICPRSBroker):Integer;
var
  strRes:String;
begin
  //Default
    Result := -1;
  //Check access
    try
      //Clear any results
        CPRSBroker.ClearParameters;
        CPRSBroker.ClearResults;
      //Call the RPC
        { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//        CPRSBroker.CallRPC('ABQMED PATMAN');
        CPRSBroker.CallRPC('TIU MED PATIENT MANAGEMENT');
      //Get the results
        strRes := Trim(CPRSBroker.Results);
        if Length(strRes) <> 1 then Exit;
        if not (strRes[1] in ['0'..'9']) then Exit;
      //Done
        Result := StrToInt(strRes);
    except
      on E:Exception do
        begin
          Result := 0;
        end;
    end;
end;
{ TODO -oHerb -cFix Error : Convert DFN from Integer to INT64 for large DFNs }
{Retrieves the contents of every dynamic object such Patient Data Objects, etc. }
//function GetDataObjects(BoilerPlate: string;DFN:integer;CPRSBroker: ICPRSBroker):string;
function GetDataObjects(BoilerPlate: string;DFN:INT64;CPRSBroker: ICPRSBroker):string;
var
  i,ie:Integer;
  BoilerNew:string;
  Tag:string;
begin
  //Have any?
    i := pos('|',BoilerPlate);
    while i > 0 do
      begin;
        //Copy text before this
          BoilerNew := BoilerNew + copy(BoilerPlate,1,i-1);
        //Now remove everything up to this point
          BoilerPlate := copy(BoilerPlate,i +1,Length(BoilerPlate));
        //Now get our closing item
          ie := pos('|',BoilerPlate);
        //Now copy this
          Tag := copy(BoilerPlate,0,ie -1);
        //Now get the value
          try
            //Clear any results
              CPRSBroker.ClearParameters;
              CPRSBroker.ClearResults;
            //Set our parameters
              CPRSBroker.Param[0] := IntToStr(DFN);
              CPRSBroker.ParamType[0] := 0;

              CPRSBroker.Param[1] := Tag;
              CPRSBroker.ParamType[1] := 0;

            //Call the RPC
              { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//              CPRSBroker.CallRPC('ABQMED GETDATAOBJ');
{ TODO -oAndrew -cSQA : TIU*1*244 v3 - new RPC call }
//              CPRSBroker.CallRPC('TIU LOAD BOILERPLATE TEXT');
              CPRSBroker.CallRPC('TIU MED GET OBJECT');
            //Get the results
              Tag := Trim(CPRSBroker.Results);
          except
            on E:Exception do
              begin
                Tag := '';
              end;
          end;
        //eate our required field and add it's reference
          BoilerNew := BoilerNew + Tag;
        //Now remove everything up to this point
          BoilerPlate := copy(BoilerPlate,ie +1,Length(BoilerPlate));
        //Next...
          i := pos('|',BoilerPlate);
      end;

  //Copy anything left to the New boilerplate
    BoilerNew := BoilerNew + BoilerPlate;

  //Done
    Result:=BoilerNew;
end;

initialization
  //Ensure an empty string
    CriticalErr := '';

  TAutoObjectFactory.Create(ComServer, TImporter, Class_Importer,
    ciMultiInstance, tmApartment);
finalization
  //Close
end.
