unit uMyClass;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses Forms, Classes, Controls, SysUtils, Windows, Messages, Dialogs, IdGlobal;

type

  TMyClass = class(TObject)
    control: TControl;
    posVal: Double;
    constructor Init(controlIn: TControl);
    function toString: string;
    function getPosVal: Double;
  end;

  TMyClasses = class(TObject)
//    owner : TObject;
    owner: TWincontrol;
    componentsOnOwner: array of TMyClass;
//    constructor Init( componentIn : TComponent);
    constructor Init(componentIn: TControl);
    function toString: string;
    procedure sort;
  end;

procedure xxCorrectTabOrder(AControl: TWinControl);
function xxComparePosition(Item1, Item2: Pointer): Integer;


implementation



const
  SLOP_FACTOR = 5;

function xxComparePosition(Item1, Item2: Pointer): Integer;
var
  Control1,
    Control2: TControl;
  XDelta,
    YDelta: Integer;
begin
  result := 0; //Note: This result should never be used in practice (all the
               //code paths below should assign a different value to a result).
               //Unfortunately, the compiler isn't always smart enough to see that.
  try

    Control1 := TObject(Item1) as TControl;
    Control2 := TObject(Item2) as TControl;

    {
    Now that we have the controls, we have to compare them to decide where they go.
    We've defined a SLOP_FACTOR constant above to allow for sloppy placement of the
    control.  I expect that in MED, the controls are all placed to the pixel
    programmatically.  This is just for demonstration purposes.
    }

    YDelta := Control1.Left - Control2.Left;
    if Abs(YDelta) <= SLOP_FACTOR then
      YDelta := 0;

    if YDelta <> 0 then
    begin
      result := YDelta;
      exit; //No need to keep going.
    end;

    {
    If we get this far, the controls are in the same column.  Now, are they in the same
    row?

    Also note: We're only comparing based on Y then X coordinates.  So, if we get to the point
    that the two controls are within SLOP_FACTOR of each other in both X and Y coordinates,
    we're just going to return 0 and let the tab order stay the same between them.

    }

    XDelta := Control1.Top - Control2.Top;
    if Abs(XDelta) < SLOP_FACTOR then
      XDelta := 0;

    result := XDelta;
  except on E: EInvalidCast do
      { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- unable to use handle}
//    MessageDlg('One of the items being sorted was not a control!', mtError, [mbOK], 0);
      MessageBox(0, PChar('One of the items being sorted was not a control!'), 'Sort Error', MB_ICONERROR or MB_OK);
  end;
end;



{ TMyClasses }

// Order the object so that the upper left most object has the lowest position
// and the lower right most object has the highest position
// by converting the x:y coordinates into a float where the y coordinate is
// the whole nubmer and the x coordinate is the deciaml then
// sorting these numbers will put them in the right tab order


//constructor TMyClasses.Init(componentIn: TComponent);

procedure xxCorrectTabOrder(AControl: TWinControl);
var
  ControlList: TList;
  I: Integer;
begin
  {
  Note: Each Control has a Controls[] array for all its children.
  So, the concept here is to sort all the controls at this level, and then tell each
  control to sort its child controls (if it has any).

  Recursion is a good thing here.

  Note also: Delphi isn't Java - while Delphi has MANY lingustic failings, one of
  the nice things about is that it doesn't require that you beat yourself to death
  trying to hammer everything into some sort of object paradigm.  It will work
  quite happily using bare (C-style) functions and procedures.
  }

  ControlList := TList.Create;
  try
    {
    First, we get everything in the list.
    }
    try
      for I := 0 to AControl.ControlCount - 1 do
        ControlList.Add(AControl.Controls[I]);

    {
    Now we sort.
    }
      ControlList.Sort(xxComparePosition);

    {
    Now that our controls are sorted, we can go back through, assign tab order,
    and fix the tab order of any sub-controls on any control that has them.
    }
      for I := 0 to ControlList.Count - 1 do
      begin
        try
          TWinControl(ControlList[I]).TabOrder := I;
        except on E: Exception do
            ShowMessage('TabOrder Error Exception:  ' + E.Message);
        end;

        try
          xxCorrectTabOrder(TWinControl(ControlList[I]));
        except on E: Exception do
            ShowMessage('Recursive Call Error Exception:  ' + E.Message);
        end;

      end;
    except on E: Exception do
        ShowMessage('Block Error Exception:  ' + E.Message);
    end;
    {
    We're done!
    }
  finally
    {
    Note: since we're just pointing at TWinControls in our TList, we don't have
    to worry about freeing them.  The form (being the controls' ultimate parent),
    will take care of that when it itself is freed.
    }

    try
      FreeAndNil(ControlList);
    except on E: Exception do
        ShowMessage('FreeAnNil Error Exception:  ' + E.Message);
    end;


  end;

end;


constructor TMyClasses.Init(componentIn: TControl);
var
  i, size: Integer;
begin
  owner := TWincontrol(componentIn);
//  size := TControl(owner).ComponentCount;
  size := owner.ControlCount;
  SetLength(componentsOnOwner, size);
  for i := 0 to size - 1 do
  begin
//      componentsOnOwner[i] := TMyClass.Init(TControl(TControl(owner).Components[i]));
    componentsOnOwner[i] := TMyClass.Init(owner.Controls[i]);
  end;
end;


{ TMyClass }

function TMyClass.getPosVal: Double;
var
  tmpStr: string;
  size: Integer;
const
  padding = '0000';
begin
  tmpStr := IntToStr(control.Left);
  size := Length(tmpStr);
  tmpStr := IntToStr(control.Top) + '.' + Copy(padding, 0, Length(padding) - size) + tmpStr;
  result := StrToFloat(tmpStr);
end;

constructor TMyClass.Init(controlIn: TControl);
begin
  control := controlIn;
  posVal := getPosVal;
end;



function TMyClass.toString: string;
begin
  Result := control.ClassName + TAB +
    ' Name: ' + control.Name + TAB +
    '  x=' + IntToStr(control.Left) + TAB +
    '  y=' + IntToStr(control.Top) + TAB +
    '  posVal=' + FloatToStr(posVal) + TAB +
    '  TabPos=' + FloatToStr(TWincontrol(control).TabOrder) + TAB +
    '  count=' + FloatToStr(control.ComponentCount); ;
end;

procedure TMyClasses.sort;
var
  i, j: Integer;
  temp: TMyClass;
begin
  for i := 0 to Length(componentsOnOwner) - 2 do
  begin
    for j := i + 1 to Length(componentsOnOwner) - 1 do
    begin
      if componentsOnOwner[i].posVal > componentsOnOwner[j].posVal then
      begin
        temp := componentsOnOwner[i];
        componentsOnOwner[i] := componentsOnOwner[j];
        componentsOnOwner[j] := temp;
      end;
    end;
  end;

  for i := 0 to Length(componentsOnOwner) - 1 do
    if componentsOnOwner[i].control is TWincontrol then
    begin
      TWincontrol(componentsOnOwner[i].control).TabOrder := i;
      TWincontrol(componentsOnOwner[i].control).TabStop := true;
    end;



end;

function TMyClasses.toString: string;
var
  i: integer;
begin
  for i := 0 to Length(componentsOnOwner) - 1 do
    OutputDebugString(pchar(IntToStr(i) + '. ' + componentsOnOwner[i].toString));
end;

end.
