unit uPatient;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface
uses
  Dialogs, SysUtils, ORFn, Forms,
     { TODO -oHerb -c508 conversion : Add Variants to uses clause for VarType }
  Variants;


type
  //Used for storing a patient record.
  TPatRecord = class(TObject)
  public

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    DFN: integer;
    DFN: INT64;

      Name: string;
    SSN: string;
    Sex: string;
    DOB: string;
    NeedSave: boolean;
    HealthSumm: string;
    ScratchPad: string;
    SecureRecord: boolean;
    ClientAdded: boolean;
    Partial: boolean;
    SortIndex: integer;
    function SetPatData(rcdPat: OleVariant): boolean; overload;
    function SetPatData(strPat: string): boolean; overload;
    function SavePatient(): boolean;
    function GetFullData(): boolean;
  end;

  TPatRecordArr = array of TPatRecord;
procedure ReleasePatList(list: TPatRecordArr; PatExclude: TPatRecord);
procedure SavePat(ToSave: TPatRecord);
implementation
uses
  uDB, uCore,
  { TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }
  VA508AccessibilityRouter;



{TPatRecord}

function TPatRecord.SetPatData(rcdPat: OleVariant): boolean;
var

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  DFN: integer;
  DFN: INT64;

  Name, SSN, DOB, SEX, HealthSumm: string;
begin
    //Default
  Result := False;
    //Ensure we have a recordset object
  if not VarType(rcdPat) = VarDispatch then
    Exit;
    //Now set our patient
  try
        //Get our values
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//    DFN := StrToInt(Nz(rcdPat.Fields['ptDFN'], '-1'));
    DFN := StrToInt64(Nz(rcdPat.Fields['ptDFN'], '-1'));
    Name := Nz(rcdPat.Fields['ptName'], '');
    SSN := Nz(rcdPat.Fields['ptSSN'], '');
    DOB := Nz(rcdPat.Fields['ptDOB'], '');
    Sex := Nz(rcdPat.Fields['ptSex'], '');

            
//          SecureRecord := (StrToInt(Nz(rcdPat.Fields['ptIsSecure'],'0')) <> 0);
    SecureRecord := Nz(rcdPat.Fields['ptIsSecure'], 'False') <> 'False';

            { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//          ClientAdded := (StrToInt(Nz(rcdPat.Fields['ptClientAdded'],'0')) <> 0);
    ClientAdded := Nz(rcdPat.Fields['ptClientAdded'], 'False') <> 'False';

          //Partial
    ScratchPad := '';
    HealthSumm := '';
    Self.Partial := True;

        //Everything's ok
    Self.DFN := DFN;
    Self.Name := Name;
    Self.SSN := SSN;
    Self.Sex := SEX;
    Self.DOB := DOB;
    Self.HealthSumm := HealthSumm;
    Result := True;
  finally
  end;
end;

function TPatRecord.GetFullData(): boolean;
begin
  //Default
  Result := True;
  //Get our health summary
  Self.HealthSumm := GetPatHealthSumm(Self);
  //Get our Scratchpad
  Self.ScratchPad := GetPatScratchPad(Self);
  //Have one?
  if ((Self.HealthSumm = '') and (Self.ScratchPad = '')) then
    Result := False;
end;

function TPatRecord.SetPatData(strPat: string): boolean;
var

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  DFN: integer;
  DFN: INT64;

  Name, SSN, DOB, SEX: string;
begin
    //Now set our patient
  try
        //Get our values
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//    DFN := StrToInt(Piece(strPat, '^', 1));
    DFN := StrToInt64(Piece(strPat, '^', 1));
    Name := Piece(strPat, '^', 2);
    SSN := Piece(strPat, '^', 4);
        { TODO -oHerb -cFix 7/15/2010 : 
Replace the CPRS Fileman date to string date due to the OR version
throwing an exception if it was not a valid date.  Errors were due to 
Incompleted dates like 5/0/1933 or 0/0/1915. }
//    DOB := DateToStr(FMDateTimeToDateTime(StrToInt(Piece(strPat, '^', 5))));
{ TODO -oherb -cImport date error : 
10/26/2010 12:05 - fix import date error by changing the stored
date/time from 'mmm d, yyyy' to 'mm/dd/yyyy' }
//    DOB := FormatFMDateTimeStr('mmm d, yyyy', Piece(strPat, '^', 5));
    DOB := FormatFMDateTimeStr('mm/dd/yyyy', Piece(strPat, '^', 5));



    Sex := Piece(strPat, '^', 3);

        //Everything's ok
    Self.DFN := DFN;
    Self.Name := Name;
    Self.SSN := SSN;
    Self.Sex := SEX;
    Self.DOB := DOB;
    Result := True;
  except
    Result := False;
    Application.HandleException(Self);
  end;
end;

function TPatRecord.SavePatient(): boolean;
var
  strSave: string;
  iExists: integer;
begin
      //Does this exist
  { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  iExists := GetCount('Patients', 'ptDFN = ' + IntToStr(Self.DFN));
  iExists := GetCount('Patients', 'ptDFN = ''' + IntToStr(Self.DFN) + '''');
  if iExists > 0 then
  begin
               //Update
               { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    strSave := 'UPDATE Patients Set ptName = ''' + SQLSafe(Self.Name) + ''', ptDOB = ''' + SQLSafe(Self.DOB) + ''', ptSSN = ''' + SQLSafe(Self.SSN) + ''', ptSex = ''' + SQLSafe(Self.Sex) + ''', ptLastUpdate = Now(),ptSortIndex = ' + IntToStr(Self.SortIndex) + ',ptScratchPad = ''' + SQLSafe(Self.ScratchPad) + ''' WHERE ptDFN = ' + IntToStr(Self.DFN);
    strSave := 'UPDATE Patients Set ptName = ''' + SQLSafe(Self.Name) + ''', ptDOB = ''' + SQLSafe(Self.DOB) + ''', ptSSN = ''' + SQLSafe(Self.SSN) + ''', ptSex = ''' + SQLSafe(Self.Sex) + ''', ptLastUpdate = Now(),ptSortIndex = ' + IntToStr(Self.SortIndex) + ',ptScratchPad = ''' + SQLSafe(Self.ScratchPad) + ''' WHERE ptDFN = ''' + IntToStr(Self.DFN) + '''';
  end
  else
  begin
               //Insert
    strSave := 'INSERT INTO Patients (ptDFN, ptName, ptDOB, ptSSN, ptSex, ptLastUpdate, ptSortIndex, ptScratchPad) VALUES(' + IntToStr(Self.DFN) + ', ''' + SQLSafe(Self.Name) + ''', ''' + SQLSafe(Self.DOB) + ''', ''' + SQLSafe(Self.SSN) + ''', ''' + SQLSafe(Self.Sex) + ''', Now(),' + IntToStr(Self.SortIndex) + ',''' + SQLSafe(Self.ScratchPad) + ''')';
  end;
      //Save our health summary to the file
         //Write our file
  if Length(Self.HealthSumm) > 0 then
    WriteFile(AppDataPath + '\db\' + IntToStr(Self.DFN) + '.hsm', Self.HealthSumm);


    //Now save it
  Result := ExecuteQuery(strSave);
    //And flag it as saved
  Self.NeedSave := False;
end;

 {Release all patients with a possible exception (e.g. a selected patient) }

procedure ReleasePatList(list: TPatRecordArr; PatExclude: TPatRecord);
var
  i: integer;
begin
  for i := Low(list) to High(list) do
  begin
    if assigned(PatExclude) and assigned(list[i]) then
    begin
      try
        if PatExclude.DFN <> list[i].DFN then
          list[i].Free;
      except
      end;
    end
    else
    try
      list[i].Free;
    except
    end;
  end;
end;

procedure SavePat(ToSave: TPatRecord);
begin
  if assigned(ToSave) then
  begin
    if ToSave.NeedSave then
      ToSave.SavePatient;
  end;
end;


end.
