unit uUser;

interface
uses SysUtils,
     { TODO -oHerb -c508 conversion : Add Variants to uses clause for VarType }
  Variants;

type
  //Used for storing a user record.
  TUserRecord = class(TObject)
  public
    UserID: integer;
      Name: string;
    Pass: string;
    Admin: boolean;
    SysAdmin: boolean;
    function SetUserData(rcdUsr: OleVariant): boolean;
    function DeleteUser(): boolean;
    function SaveUser(): boolean;
  end;

  TUserRecordArr = array of TUserRecord;
procedure ReleaseUserList(list: TUserRecordArr);

implementation
uses uDB, uCore;
{TUserRecord}

function TUserRecord.SetUserData(rcdUsr: OleVariant): boolean;
var
  ID: integer;
  Name, Pass: string;
  Admin, SysAdmin: boolean;
begin
    //Default
  Result := False;
    //Ensure we have a recordset object
  if not VarType(rcdUsr) = VarDispatch then
    Exit;
    //Now set our patient
  try
        //Get our values
    ID := StrToInt(Nz(rcdUsr.Fields['usRfnbr'], '-1'));
    Name := Nz(rcdUsr.Fields['usName'], '');
    Pass := Nz(rcdUsr.Fields['usPass'], '');

     { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//    Admin := (Nz(rcdUsr.Fields['usAdmin'], '0') <> '0');
    Admin := (Nz(rcdUsr.Fields['usAdmin'], 'False') <> 'False');

     { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//    SysAdmin := (Nz(rcdUsr.Fields['usSysAdmin'], '0') <> '0');
    SysAdmin := (Nz(rcdUsr.Fields['usSysAdmin'], 'False') <> 'False');


        //Everything's ok
    Self.UserID := ID;
    Self.Name := Name;
    Self.Pass := Pass;
    Self.Admin := Admin;
    Self.SysAdmin := SysAdmin;
    Result := True;
  finally
  end;
end;

function TUserRecord.DeleteUser(): boolean;
var
  strDel: string;
begin
    //Default
  Result := False;
    //Can we delete this from the db?
  if Self.UserID <= 0 then Exit; //No.
    //Create our delete query
  strDel := 'DELETE from Users WHERE usRfnbr = ' + IntToStr(Self.UserID);
    //Now delete it
  Result := ExecuteQuery(strDel);
end;

{Release all users }

procedure ReleaseUserList(list: TUserRecordArr);
var
  i: integer;
begin
  for i := Low(list) to High(list) do
    list[i].Free;
end;
end.
