unit fAboutMED;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ORFn, compile_time, VA508AccessibilityManager, jpeg, Constants;

const
  BUILD_PHASE = ' BETA';

type
  TfrmAboutMED = class(TForm)
    btnOK: TButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    lblMED: TStaticText;
    lblVersion: TStaticText;
    lblDevBy: TStaticText;
    lblCompiled: TStaticText;
    lblForCRC: TStaticText;
    lblCRC: TStaticText;
    lblLocAndDevoper: TStaticText;
    lblIncludesTemplates: TStaticText;
    lblWarning1: TStaticText;
    lblWarning2: TStaticText;
    lblWarning3: TStaticText;
    lblWarning4: TStaticText;
    lblPatch: TStaticText;
    lblServerReq: TStaticText;
    Image1: TImage;
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure ShowAbout();
    procedure ShowSplash();
  end;

var
  frmAboutMED: TfrmAboutMED;

implementation

uses
  VA508AccessibilityRouter,
  VAUtils;

{$R *.DFM}

procedure TfrmAboutMED.ShowAbout();
begin
  //Adjust the height.
  { TODO -oHerb -cSACC :
Need to increase the height from 410 to 500 to accommodate the
4th line of the warning box }
  Self.Height := 500;
  //Change the caption.
  Self.Caption := 'About Mobile Electronic Documentation';
  //Enable the close on the menubar
  Self.BorderIcons := [biSystemMenu];
  //Show modal
  Self.ShowModal;
end;

procedure TfrmAboutMED.ShowSplash();
begin
  //Adjust the height.
  Self.Height := 290;
  //Change the caption.
  Self.Caption := 'Mobile Electronic Documentation';
  //Enable the close on the menubar
  Self.BorderIcons := [];
  //Show modal
  Self.Visible := True;
end;

procedure TfrmAboutMED.btnOKClick(Sender: TObject);
begin
  //Close the about form
  Self.Close;
end;

procedure TfrmAboutMED.FormCreate(Sender: TObject);
const
  numI = 10;
var
  strVer: string;
  Enum: TComponentEnumerator;
  { TODO -oHerb -cSACC : Get compile time from sysutil per Brian }
  exeName: string; //name of application exe
  exeDateTime: TDateTime; // date and time of application exe
begin
  {
  blj 9 June 2009 - 508
  We've changed the patient name, DOB, and SSN labels from labels to static
  text components.  Now, we need to go through and see if a screen reader is
  running.  If it is, then we need to enable the tab stops for the static text
  components.
  }

    lblMED.TabStop := ScreenReaderSystemActive;
    lblVersion.TabStop := ScreenReaderSystemActive;
    lblDevBy.TabStop := ScreenReaderSystemActive;
    lblCompiled.TabStop := ScreenReaderSystemActive;
    lblForCRC.TabStop := ScreenReaderSystemActive;
    lblCRC.TabStop := ScreenReaderSystemActive;
    lblLocAndDevoper.TabStop := ScreenReaderSystemActive;
    lblIncludesTemplates.TabStop := ScreenReaderSystemActive;
    lblWarning1.TabStop := ScreenReaderSystemActive;
    lblWarning2.TabStop := ScreenReaderSystemActive;
    lblWarning3.TabStop := ScreenReaderSystemActive;
    lblWarning4.TabStop := ScreenReaderSystemActive;
    lblPatch.TabStop := ScreenReaderSystemActive;
    lblServerReq.TabStop := ScreenReaderSystemActive;


  Enum := GetEnumerator;
  try
    while Enum.MoveNext do
      if Enum.Current is TStaticText then
        with Enum.Current as TStaticText do
          TabStop := ScreenReaderSystemActive;
  finally
    FreeAndNil(Enum);
  end;

  // Store the Patch Number info
  lblPatch.Caption := FileVersionValue(Application.ExeName, FILE_VER_ORIGINALFILENAME);  //patch

  //Store our version info
  strVer := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  lblVersion.Caption := 'Version ' + strVer;

  // make the server required the same as the version number
  lblServerReq.Caption := strVer + ' server required';

  //Calculate our CRC
  lblCRC.Caption := IntToHex(CRCForFile(Application.ExeName), 4);

  //Compilation Date
    { TODO -oHerb -cSACC : Get compile time from sysutil per Brian }
//    lblCompiled.Caption := 'Compiled ' + COMP_TIME;
  exeName := Application.ExeName;
  FileAge(exeName, exeDateTime);
  lblCompiled.Caption := 'Compiled ' + DateToStr(exeDateTime);


    { TODO -oHerb -c508 : Need to say something on splash screen - trying the speak function }
  GetScreenReader.Speak('Splash Screen, MED Image, ' +
    lblMed.Caption + ' ' +
    lblVersion.Caption + ' ' +
    lblDevBy.Caption + ' ' +
    lblLocAndDevoper.Caption + ' ' +
    lblPatch.Caption + ' ' +
    lblServerReq.Caption + ' ' +
    lblIncludesTemplates.Caption);

end;

end.
