unit fGetPat;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Trpcb, StdCtrls, ComCtrls, ORCtrls, ORFn, uCore, uDB, uPatient, ExtCtrls,
  ORDtTm, VA508AccessibilityManager, uUtils, RPCConf1;

type
  TfrmGetPat = class(TForm)
    rpcBroker: TRPCBroker;
    btnClose: TButton;
    pgPages: TPageControl;
    tbSelect: TTabSheet;
    tbPersList: TTabSheet;
    btnBack: TButton;
    orPersLists: TORComboBox;
    orPatList: TORComboBox;
    grpPatInfo: TGroupBox;
    btnAddNew: TButton;
    lblManEntryDesc: TLabel;
    btnSelPat: TButton;
    lblSelectPatDesc: TLabel;
    btnPersList: TButton;
    lblRetrieveDesc: TLabel;
    pgList: TProgressBar;
    tbPatSel: TTabSheet;
    orPatients: TORComboBox;
    tbPatEnter: TTabSheet;
    btnRetrieve: TButton;
    lblManPatName: TLabel;
    edtName: TEdit;
    lblManPtDOB: TLabel;
    lblManPtSSN: TLabel;
    edtSSN: TEdit;
    lblManualPtInst: TLabel;
    VA508AccMgrRetrievePts: TVA508AccessibilityManager;
    lblName: TStaticText;
    lblSEX: TStaticText;
    lblSSN: TStaticText;
    lblDOB: TStaticText;
    ordDOB: TDateTimePicker;
    VA508AccManPtDOB: TVA508ComponentAccessibility;
    lblRetrievePatInst: TStaticText;
    VA508CompAccBtnPersList: TVA508ComponentAccessibility;
    VA508CompAccBtnSelPat: TVA508ComponentAccessibility;
    VA508CompAccBtnAddNew: TVA508ComponentAccessibility;
    lblPersonalList: TStaticText;
    lblPersListPatients: TStaticText;
    lblManualPtInst1: TStaticText;
    lblManualPtInst2: TStaticText;
    lblManualPtInstt3: TStaticText;
    VA508CompAccOrPatList: TVA508ComponentAccessibility;
    btnCheckUnCheck: TButton;
    ConPanel: TPanel;
    ConPnlMsg: TStaticText;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCloseClick(Sender: TObject);
    procedure btnPersListClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ChangePage(ToPage: TTabSheet);
    procedure orPersListsChange(Sender: TObject);
    procedure orPatListClick(Sender: TObject);
    procedure btnRetrieveClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnSelPatClick(Sender: TObject);
    procedure orPatientsNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure orPatientsKeyPause(Sender: TObject);
    procedure orPatientsClick(Sender: TObject);
    procedure btnAddNewClick(Sender: TObject);
    procedure edtNameChange(Sender: TObject);
    procedure edtSSNChange(Sender: TObject);
    procedure orSexChange(Sender: TObject);
    procedure orSexExit(Sender: TObject);
    procedure orPatientsDblClick(Sender: TObject);
    procedure ordDOBChange(Sender: TObject);
    procedure tbPatEnterEnter(Sender: TObject);
    procedure orPatListChange(Sender: TObject);
    procedure btnCheckUnCheckClick(Sender: TObject);
  private
    { Private declarations }
    blnDisClose: Boolean;
    blnSelectedSecure: Boolean;
    fVersionChecked: Boolean;
    fVersionOK: Boolean;
    { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    PatIEN: Integer;
    PatIEN: INT64;

    function PersLists(): TStrings;

    { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    function PersListsPats(ForList: Integer): TStrings;
    function PersListsPats(ForList: INT64): TStrings;


    procedure CallBroker();
    { TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls. MyErrorHandler(RPCBroker: TRPCBroker)
from C:\Program Files\VistA\BDK32\Samples\SilentSignOn\fXWBOnFail.pas}
    procedure MyErrorHandler(RPCBroker: TRPCBroker);
    procedure CleanBroker();
    procedure InitPersList();
    procedure InitPatList();
    procedure InitPatEnter();
    procedure InitPLPatList();
    procedure ClearPatientData();
    procedure ShowPatientData(Data: string);

    { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    function GetPatientData(ForIEN: Integer; BypassSec, GetHS: boolean): TStrings;
    function GetPatientData(ForIEN: INT64; BypassSec, GetHS: boolean): TStrings;

    { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    function AccessRecord(PatientIEN: Integer; Message: string; IsMultiple: Boolean): Integer;
    function AccessRecord(PatientIEN: INT64; Message: string; IsMultiple: Boolean): Integer;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    function AddPatient(PatientIEN: Integer; IsSecure: Boolean; Message: string; IsMultiple: Boolean): Integer;
    function AddPatient(PatientIEN: INT64; IsSecure: Boolean; Message: string; IsMultiple: Boolean): Integer;


    function AddManualPatient(Name: string; SSN: string; DOB: string): Boolean;
    procedure PersListRetButton();
    function SubSetOfPatients(const StartFrom: string; Direction: Integer): TStrings;
    procedure GetLast5(Dest: TStrings; const Last5: string);
    procedure UpdatePatientGUI();

    function IsVersionOK: boolean;
    procedure EnsureConnection;
  public
    { Public declarations }
  end;

var
  frmGetPat: TfrmGetPat;

const
  TIUMEDVER = 'TIU MED GUI RPC V2';

implementation

{ TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }
uses VA508AccessibilityRouter, System.UITypes;

{$R *.DFM}

procedure TfrmGetPat.ClearPatientData();
begin
  PatIEN := 0;
  { TODO -oHerb -c508 : Changed single lbl to lbl with static text }
  { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
  lblName.Caption := 'Name:';
  lblSSN.Caption := 'SSN:';
  lblDOB.Caption := 'DOB:';
  lblSex.Caption := 'Sex:';
end;

procedure TfrmGetPat.ShowPatientData(Data: string);
var
  patName, patSSN, patSex, patDOB, patSec: string;
  va508Text : string;
begin
  PatName := Piece(Data, U, 2);
  PatSSN := Piece(Data, U, 4);
  PatSex := Piece(Data, U, 3);
  PatDOB := Piece(Data, U, 5);
  PatSec:=Piece(Data,U,6);

  //Ensure it's complete
  if (PatName = '') then Exit;

  //Show our display
  { TODO -oHerb -c508 : Changed single lbl to lbl with static text } { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
  lblName.Caption := 'Name: ' + PatName;

  if StrToInt(PatSec) <> 0 then
  begin
    blnSelectedSecure := True;
      { TODO -oHerb -c508 : Changed single lbl to lbl with static text }
      { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
      { TODO -oHerb -cCode Review : Brian said it was a patient safety issue not to display the information. }
//      lblSSN.Caption := 'SSN: *SECURE*';
      lblSSN.Caption := 'SSN: ' + FormatSSN(PatSSN);
//      lblDOB.Caption := 'DOB: *SECURE*';
      lblDOB.Caption := 'DOB: ' + FormatFMDateTimeStr('mmm d, yyyy', PatDOB);
//      lblSex.Caption := 'Sex: *SECURE*';
      lblSex.Caption := 'Sex: ' + CodeArrSet(PatSex,['M','F'],['Male','Female']);


  end
  else
  begin
    blnSelectedSecure := False;
      { TODO -oHerb -c508 : Changed single lbl to lbl with static text }
      { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
      lblSSN.Caption := 'SSN: ' + FormatSSN(PatSSN);
      lblDOB.Caption := 'DOB: ' + FormatFMDateTimeStr('mmm d, yyyy', PatDOB);
      lblSex.Caption := 'Sex: ' + CodeArrSet(PatSex,['M','F'],['Male','Female']);
  end;

    { TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }
    { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
//  GetScreenReader.Speak(lblName.Caption + ', ' + lblSSN.Caption + ', ' + lblDOB.Caption + ', ' + lblSex.Caption);

  { TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }

if ScreenReaderSystemActive  then
begin
      va508Text := 'Name ' + PatName +
                   'SSN: ' + FormatSSN(PatSSN) +
                   'DOB: ' + FormatFMDateTimeStr('mmm d, yyyy', PatDOB) +
                   'Sex: ' + CodeArrSet(PatSex,['M','F'],['Male','Female']);

      if orPatList.checked[orPatList.itemindex] then
        va508Text := va508Text + ' Checked'
      else
        va508Text := va508Text + ' Unchecked';
      GetScreenReader.Speak(va508Text);
end;



end;

procedure TfrmGetPat.ChangePage(ToPage: TTabSheet);
begin
  //Change it
  pgPages.ActivePage := ToPage;

  //And reflect status
  if ToPage = tbSelect then
    btnBack.Visible := False
  else
    btnBack.Visible := True;

  //Defaults
  btnRetrieve.Enabled := False;
  btnBack.Visible := True;
  btnRetrieve.Visible := True;
  grpPatInfo.Visible := True;

  //Change GUI
  if ToPage = tbSelect then
  begin
    grpPatInfo.Visible := False;
    btnRetrieve.Visible := False;
    btnBack.Visible := False;
    Self.Caption := 'Retrieve Patient(s)';
  end
  else if ToPage = tbPersList then
  begin
      //Change the captions
    Self.Caption := 'Retrieve Patient(s) :  Personal Lists';
    btnRetrieve.Caption := 'Retrieve Checked Patients';
      //And get the lists
    InitPersList;
  end
  else if ToPage = tbPatSel then
  begin
      //Change the captions
    Self.Caption := 'Retrieve Patient(s) : Select Patient';
    btnRetrieve.Caption := 'Retrieve Patient';
      //And get the list
    InitPatList;
  end
  else if Topage = tbPatEnter then
  begin
      //Change the captions
    Self.Caption := 'Retrieve Patient(s) : Manually enter a Patient';
    btnRetrieve.Caption := 'Save Patient';
      //Hide patient info (since the user is entering it)
    grpPatInfo.Visible := False;
      //And init the variables
    InitPatEnter();
  end;
end;

procedure TfrmGetPat.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //Ensure our broker is closed
  rpcBroker.Connected := False;
end;

procedure TfrmGetPat.btnCheckUnCheckClick(Sender: TObject);
const
  strPatChecked = 'Uncheck All Patients on List';
  strPatUnChecked = 'Check All Patients on List';
var
  checked : Boolean;
  iCheck : Integer;
begin
  // are we checking or unchecking the patients on the list?
  checked := btnCheckUnCheck.Caption = strPatChecked;

  // ok lets loop through the list and flip the checked box
  for iCheck := 0 to orPatList.Items.Count - 1 do
  begin
    orPatList.Checked[iCheck] := not checked;
  end;

  // no change the caption on the button to match the checked state
  if checked then
    begin
      btnCheckUnCheck.Caption := strPatUnChecked;
      if ScreenReaderSystemActive  then
        GetScreenReader.Speak('All patients unchecked.');
    end
  else
    begin
      btnCheckUnCheck.Caption := strPatChecked;
      if ScreenReaderSystemActive  then
        GetScreenReader.Speak('All patients checked.');
    end;

end;

procedure TfrmGetPat.btnCloseClick(Sender: TObject);
begin
  //Close this window
  Self.Close();
end;

procedure TfrmGetPat.btnPersListClick(Sender: TObject);
begin
  ChangePage(tbPersList);
end;

procedure TfrmGetPat.btnBackClick(Sender: TObject);
begin
  //Go "back" to the main page
  ChangePage(tbSelect);
end;

procedure TfrmGetPat.FormCreate(Sender: TObject);
begin
  { TODO -oHerb -c508 : Setup the 508 components }
  VA508CompAccBtnPersList.Instructions := lblRetrieveDesc.Caption;
  VA508AccMgrRetrievePts.RefreshComponents;
  VA508CompAccBtnSelPat.Instructions := lblSelectPatDesc.Caption;
  VA508AccMgrRetrievePts.RefreshComponents;
  VA508CompAccBtnAddNew.Instructions := lblManEntryDesc.Caption;
  VA508AccMgrRetrievePts.RefreshComponents;

  { TODO -oHerb -c508 : Adding Tabstop to TStaticText Controls }
    lblName.TabStop := ScreenReaderSystemActive;
    lblSEX.TabStop := ScreenReaderSystemActive;
    lblSSN.TabStop := ScreenReaderSystemActive;
    lblDOB.TabStop := ScreenReaderSystemActive;
    lblRetrievePatInst.TabStop := ScreenReaderSystemActive;
    lblPersonalList.TabStop := ScreenReaderSystemActive;
    lblPersListPatients.TabStop := ScreenReaderSystemActive;
    lblManualPtInst1.TabStop := ScreenReaderSystemActive;
    lblManualPtInst2.TabStop := ScreenReaderSystemActive;
    lblManualPtInstt3.TabStop := ScreenReaderSystemActive;

  //Default some variables
  fVersionChecked := false;
  fVersionOK := false;

  //Default page
  ChangePage(tbSelect);
end;

function TfrmGetPat.PersLists(): TStrings;
begin
  //Prepare
  CleanBroker();
    { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//    rpcBroker.RemoteProcedure := 'ABQMED PLISTS';
  rpcBroker.RemoteProcedure := 'TIU MED GET PATIENT LISTS';
  //Invoke
  CallBroker();
  //Cleanup
  MixedCaseList(rpcBroker.Results);
  //Return
  Result := rpcBroker.Results;
end;

{ TODO -oHerb -cIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function TfrmGetPat.PersListsPats(ForList: Integer): TStrings;
function TfrmGetPat.PersListsPats(ForList: INT64): TStrings;
begin
  //Prepare
  CleanBroker();
    { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//    rpcBroker.RemoteProcedure := 'ABQMED PLISTMEM';
  rpcBroker.RemoteProcedure := 'TIU MED GET LIST DATA';
  //Personal List
  rpcBroker.Param[0].PType := literal;
  rpcBroker.Param[0].Value := IntToStr(ForList);
  //Invoke
  CallBroker();
  //Return
  Result := rpcBroker.Results;
end;

function TfrmGetPat.SubSetOfPatients(const StartFrom: string; Direction: Integer): TStrings;
begin
  //Prepare
  CleanBroker();
    { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//    rpcBroker.RemoteProcedure := 'ABQMED LISTALL';
  rpcBroker.RemoteProcedure := 'TIU MED LIST ALL';
  //Params
    //From
  rpcBroker.Param[0].PType := literal;
  rpcBroker.Param[0].Value := StartFrom;
    //DIR?
  rpcBroker.Param[1].Value := IntToStr(Direction);
  rpcBroker.Param[1].PType := literal;
  //Invoke
  CallBroker();
  //Cleanup
    //MixedCaseList(rpcBroker.Results);
  //Return
  Result := rpcBroker.Results;
end;

procedure TfrmGetPat.InitPatList();
begin
  //Get the items
  orPatients.Items.Clear;
  orPatients.InitLongList('');
  //Ensure we have items
  if (orPatients.Items.Count = 0) AND rpcBroker.Connected then  //SMT only display this if we have a connection, and don't see any patients.
  begin

    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//  ShowMessage('There are no patients to select from');
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(0, PChar('There are no patients to select from'), '', MB_ICONERROR or MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmGetPat.Handle, PChar('There are no patients to select from'), '', MB_ICONERROR or MB_OK);
    MessageBox( self.Handle, PChar('There are no patients to select from'), '', MB_ICONERROR or MB_OK);

    ChangePage(tbSelect); //Change back to the selection
  end;
end;

procedure TfrmGetPat.InitPersList();
begin
  //Get the items
  orPersLists.Items.Clear;
  orPersLists.Items.AddStrings(PersLists());
  //Ensure we have items
  if (orPersLists.Items.Count = 0) AND rpcBroker.Connected then   //SMT Only need to send this message if we have a broker connection.
  begin
 { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//  ShowMessage('There are no personal lists to select from');
  { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//  MessageBox(0, PChar('There are no personal lists to select from'), '', MB_ICONERROR or MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//  MessageBox( frmGetPat.Handle, PChar('There are no personal lists to select from'), '', MB_ICONERROR or MB_OK);
    MessageBox( self.Handle, PChar('There are no personal lists to select from'), '', MB_ICONERROR or MB_OK);
    ChangePage(tbSelect); //Change back to the selection
  end;
end;

procedure TfrmGetPat.InitPLPatList();
var
  iCheck: Integer;
begin
  //Clear prior selection
  ClearPatientData();

  //Ensure we have something to work with
  if orPersLists.ItemIEN = 0 then Exit;

  //Clear prior
  orPatList.Items.Clear;

  //Get the data
  orPatList.Items.AddStrings(PersListsPats(orPersLists.ItemIEN));

  //Have any?
  if orPatList.Items.count = 0 then
  begin
    orPatList.Text := '';
    orPatList.Enabled := False;
    orPatList.CheckBoxes := false;
    orPatList.Items.Add('-1^* No patients in this list *');
  end
  else
  begin
    orPatList.Enabled := True;
    orPatList.CheckBoxes := True;
  end;

  //And check all by default
  for iCheck := 0 to orPatList.Items.Count - 1 do
  begin
    orPatList.Checked[iCheck] := True;
  end;
end;

procedure TfrmGetPat.EnsureConnection;

Procedure HideObjects(Toggle: Boolean);
const
 ConMsg = 'Connecting to %s. Please wait';
begin
 if Toggle then
 begin
  ConPnlMsg.Caption := Format(ConPnlMsg.Caption, [rpcBroker.Server]);
  ConPnlMsg.Visible := true;
  ConPanel.Visible := true;
  ConPanel.BringToFront;
 end else begin
  ConPnlMsg.Caption := ConMsg;
  ConPanel.Visible := false;
 end;
end;

var
 CloneRPCName: String;
 CloneRPCParam: TParams;
 RtnCursor: Integer;
const
 ContextErr = 'There was an issue with the server software. Please contact local support staff for help.';
 ConnectionErr = 'There was a problem connecting to %s on port %s. Please ensure these are correct and try again. If this problem persist please contact your local help desk';
begin
 //Only need to do this if we have not connected
 if not rpcBroker.Connected then
 begin
   //Set the server and port
   if (Trim(Server) = '') or (Trim(port) = '') then
   GetServerInfo(Server, Port);

   if Server <> '' then
     rpcBroker.Server := Server;
   if IsNumeric(Port) then
     rpcBroker.ListenerPort := StrToInt(Port);

   //Set the RPC timeout
   rpcBroker.RPCTimeLimit := 120;
   RtnCursor := Screen.Cursor;
   Screen.Cursor := crHourGlass;
   HideObjects(true);
   try
     //Try to connect and if not then close the form
     rpcBroker.Connected := True;
    finally
      Screen.Cursor := RtnCursor;
      HideObjects(false);
      if NOT rpcBroker.Connected then   //SMT Close the form, if the user cancels broker conenction.
       begin
         TaskMessageDlg('Connection error', Format(ConnectionErr, [Server, Port]),mtError, [mbOK], 0);
         Close;
       end;
    end;

    //Set up the context
    Try
    if rpcBroker.CurrentContext <> TIUMEDVER then
        rpcBroker.CreateContext(TIUMEDVER);
    except
      TaskMessageDlg('Server Error', ContextErr, mtError, [mbOK], 0);
      Close;
      Exit;
    End;

    //Ensure the context was set
    if rpcBroker.CurrentContext <> TIUMEDVER then //SMT If no context, bail out
    begin
      rpcBroker.Connected := False;
      rpcBroker.ClearResults := True;
      TaskMessageDlg('Server Error', ContextErr, mtError, [mbOK], 0);
      Close;
      Exit;
    end;

    rpcBroker.OnRPCBFailure := MyErrorHandler;

    //Clone RPC data
    CloneRPCParam := TParams.Create(self);
    try
      CloneRPCName := rpcBroker.RemoteProcedure;
      CloneRPCParam.Assign(rpcBroker.Param);
      CleanBroker;

      //Check for the latest version (message handled in function)
      if not IsVersionOK then
      begin
        Close;
        Exit;
      end;

    //Restore RPC data
    CleanBroker;
    rpcBroker.RemoteProcedure := CloneRPCName;
    rpcBroker.Param.Assign(CloneRPCParam);
    Finally
     CloneRPCParam.Free;
    end;
 end;

end;

procedure TfrmGetPat.CallBroker();
begin
  //ensure that we are connected
  EnsureConnection;

  //Exec
  rpcBroker.Call;

  //Cancelled?
  //SMT don't display a blank form when we don't connect.
  if rpcBroker.Connected = false then
  begin
    rpcBroker.ClearResults := True;
    Close;
  end;
end;
{
procedure TfrmGetPat.CallBroker();
begin
{ TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls. }
//  try
    //Params

{  if Server <> '' then
    rpcBroker.Server := Server;
  if IsNumeric(Port) then
    rpcBroker.ListenerPort := StrToInt(Port);
    //connect
    { TODO -oShawn -cField Testing Issue :
Field testing WINDSOCKERROR due to broker time out.
Changed Time Limit from default to 120. }
{  rpcBroker.RPCTimeLimit := 120;
  try
    rpcBroker.Connected := True;
  finally
    if NOT rpcBroker.Connected then   //SMT Close the form, if the user cancels broker conenction.
       Close;
  end;
    //Context?
      { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//      if rpcBroker.CurrentContext <> 'ABQMED RPC' then
//        rpcBroker.CreateContext('ABQMED RPC');
          { TODO -oHerb -cTIU*1*257 VERSION CONTROL 10/15/2010 changed the context name to prevent
                                     older version of MED from running and forcing the install of
                                     TIU*1*257 before running the code.}
//  if rpcBroker.CurrentContext <> 'TIU MED GUI RPC' then
//    rpcBroker.CreateContext('TIU MED GUI RPC');
{  try
  if rpcBroker.CurrentContext <> TIUMEDVER then
      rpcBroker.CreateContext(TIUMEDVER);
  except on E: Exception do
      MessageBox( self.Handle, PChar('You are not running the Current version of MED' +
                                      #13#10 +
                                      'Please install '+PATCH_VER+' before retrieving new patients.'),
                   'Wrong Version', MB_ICONERROR or MB_OK);

  end;

  if rpcBroker.CurrentContext <> TIUMEDVER then //SMT If no context, bail out
  begin
    rpcBroker.Connected := False;
    rpcBroker.ClearResults := True;
    Close;
    Exit;
  end;
    { TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls. MyErrorHandler(RPCBroker: TRPCBroker)
from C:\Program Files\VistA\BDK32\Samples\SilentSignOn\fXWBOnFail.pas}

{  rpcBroker.OnRPCBFailure := MyErrorHandler;

    //Exec
  rpcBroker.Call;
    //Cancelled?

  //SMT don't display a blank form when we don't connect.
  if rpcBroker.Connected = false then
  begin
    rpcBroker.ClearResults := True;
    Close;
  end;

{ TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls.

    ***************  IF AN ERROR EXCEPTION OCCURES PASS IT BACK UP *****************
}
//  except on E:Exception do
//    begin
        { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//        ShowMessage('Broker Error:' + E.Message);
          { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//        MessageBox(0, PChar('Broker Error:' + E.Message), '', MB_ICONERROR or MB_OK);
//        MessageBox( frmGetPat.Handle, PChar('Broker Error:' + E.Message), '', MB_ICONERROR or MB_OK);
//      rpcBroker.Results.Clear;
//    end;
//  end;
{end;
}
function TfrmGetPat.IsVersionOK: boolean;

 Function GetReqVersion: String;
 begin
   Result := '';
   CleanBroker;
   rpcBroker.RemoteProcedure := 'TIU MED GET VERSION';
   rpcBroker.Call;
   if rpcBroker.Results.Count > 0 then
    Result := rpcBroker.Results[0];
 end;

const
MisMatchMsg = 'This running version of MED (%s) is not compatible with the current server software (%s). ' +
 'Please contact local support staff to obtain a compatible version of the GUI';
var
 ReqVer, ClientVer: String;
begin
 if not fVersionChecked then
 begin
   ClientVer := ClientVersion(Application.ExeName);
   ReqVer := GetReqVersion;
  if (CompareVersion(ClientVer, ReqVer) <> 0) then
  begin
    TaskMessageDlg('Version Mismatch', Format(MisMatchMsg, [ClientVer, ReqVer]), mtError,[mbok],0);
    fVersionOK := false;
  end else
   fVersionOK := true;

  fVersionChecked := true;
 end;

 result := fVersionOK;
end;

    { TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls. MyErrorHandler(RPCBroker: TRPCBroker)
from C:\Program Files\VistA\BDK32\Samples\SilentSignOn\fXWBOnFail.pas}

procedure TfrmGetPat.MyErrorHandler(RPCBroker: TRPCBroker);
var
  ErrorText: string;
  Path: string;
  StrLoc: TStringList;
  NowVal: TDateTime;
begin
  NowVal := Now;
  ErrorText := rpcBroker.RPCBError;
  StrLoc := TStringList.Create;
    { TODO -oHERB -cCosmetic : Need to return to main form on error.  7/28/2018 }
   PatSelStatus := 0;

{ TODO -oHerb -cSACC : Try/finally with FreeAndNil(StrLoc) added per Brian }
  try
    Path := IncludeTrailingPathDelimiter(AppDataPath);
    Path := Path + 'Error.Log';
    if FileExists(Path) then
      StrLoc.LoadFromFile(Path);
    StrLoc.Add(FormatDateTime('mm/dd/yyyy hh:mm:ss  ', NowVal) + ErrorText);
    StrLoc.SaveToFile(Path);
  finally
    FreeAndNil(StrLoc);
  end;

  { TODO -oHerb -cBeta Test bug :
During Beta testing a Health Summary error in Vista was not being
passed back up from CallBroker() calls.

         After loggin now show the error and then pass the exception back up the chain
}
 { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//  ShowMessage( 'An error occured.  Please contact IRM/ISS and give them the error:  ' + ErrorText );
  { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//  MessageBox(0, PChar('An error occured.  Please contact IRM/ISS and give them the error' + ErrorText), '', MB_ICONERROR or MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//  MessageBox( frmGetPat.Handle, PChar('An error occured.  Please contact IRM/ISS and give them the error' + ErrorText), '', MB_ICONERROR or MB_OK);
  MessageBox( self.Handle, PChar('An error occured.  Please contact IRM/ISS and give them the error: ' + ErrorText), '', MB_ICONERROR or MB_OK);




  raise Exception.Create(ErrorText);

end;

procedure TfrmGetPat.CleanBroker();
begin
  rpcBroker.ClearResults := True;
  rpcBroker.ClearParameters := True;
end;

procedure TfrmGetPat.PersListRetButton();
begin
  btnRetrieve.enabled := (Pos('1', orpatlist.CheckedString) <> 0);
end;

procedure TfrmGetPat.orPersListsChange(Sender: TObject);
begin
  //Ensure we're dealing with our page
  if pgPages.ActivePage <> tbPersList then Exit;
  //Init the list
          { TODO -oHerb -c508 : Add Brian's code for the TORComboBox to speak the fields. }
          // is this going to work?????
  if orPersLists.ItemIndex >= 0 then
    GetScreenReader.Speak('Personal List ' + Piece(orPersLists.Items.Strings[orPersLists.ItemIndex], '^', 2));

  InitPLPatList;
  //How many are checked?
  PersListRetButton;
end;


{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function TfrmGetPat.GetPatientData(ForIEN: Integer; BypassSec, GetHS: boolean): TStrings;
function TfrmGetPat.GetPatientData(ForIEN: INT64; BypassSec, GetHS: boolean): TStrings;
begin
  //Prepare
  CleanBroker();
    { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//    rpcBroker.RemoteProcedure := 'ABQMED GETPATDT';
  rpcBroker.RemoteProcedure := 'TIU MED GET PATIENT DATA';
   //Params
      //ForIEN
  rpcBroker.Param[0].PType := literal;
  rpcBroker.Param[0].Value := IntToStr(ForIEN);
      //Bypass Secure?
  rpcBroker.Param[1].PType := literal;
  if BypassSec then
    rpcBroker.Param[1].Value := '1'
  else
    rpcBroker.Param[1].Value := '0';
      //GenHS
  rpcBroker.Param[2].PType := literal;
  if GetHS then
    rpcBroker.Param[2].Value := '1'
  else
    rpcBroker.Param[2].Value := '0';

  //Invoke
  CallBroker();

  //Have nothing?
  if rpcBroker.Results.Count = 0 then
    rpcBroker.Results.Add(''); //Ensure there is at least one (e.g. for ShowPatientData)

  //Return
  Result := rpcBroker.Results;
end;

procedure TfrmGetPat.orPatListChange(Sender: TObject);
var
  va508Text : string;
begin

if ScreenReaderSystemActive  then
begin
  if orPatList.ItemIndex > 0 then
  begin
        va508Text :=  piece(orPatList.Items[orPatList.ItemIndex],'^',2) ;
  
        if orPatList.checked[orPatList.itemindex] then
            va508Text := va508Text + ' Checked)'
        else
            va508Text := va508Text + ' Unchecked';
  
         GetScreenReader.Speak(va508Text);
  end;
    
end;

end;

procedure TfrmGetPat.orPatListClick(Sender: TObject);
begin
  //Ensure we're dealing with our page
  if pgPages.ActivePage <> tbPersList then Exit;

  //Clear
  ClearPatientData();
  //Get/Show the Data
  if orPatList.ItemIEN > 0 then
  begin
    PatIEN := orPatList.ItemIEN;
      //Get the Patient Information
    ShowPatientData(GetPatientData(PatIEN, False, False)[0]);
  end;
  //How many are checked?
  PersListRetButton;        // disable button if no patients are checked.

end;

procedure TfrmGetPat.btnRetrieveClick(Sender: TObject);
var
{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  iSec, iPat, PatientIEN: Integer;
  iSec, iPat : Integer;
  PatientIEN: INT64;

  PatName: string;
  iCount: Integer;
  iPass: Integer;
  bSensitive: Boolean;
begin
  //Reset count
  iCount := 0;

  //Lock
  blnDisClose := True;
  btnClose.Enabled := False;
  btnBack.Enabled := False;

  //What are we doing?
  if pgPages.ActivePage = tbPatSel then
  begin
      //Have one?
    if orPatients.ItemIEN > 0 then
    begin
          //Attempt to add the patient
      iSec := AddPatient(orPatients.ItemIEN, blnSelectedSecure, '', False);
      if iSec = 1 then
      begin
//        GetScreenReader.Speak('Patient record retrieved');   // below should have fixed this -oHerb -c508
        { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//        ShowMessage('Patient record retrieved');
        { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//        MessageBox(0, PChar('Patient record retrieved'), 'Informational', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//        MessageBox( frmGetPat.Handle, PChar('Patient record retrieved'), 'Informational', MB_OK);
        MessageBox( self.Handle, PChar('Patient record retrieved'), 'Informational', MB_OK);
      end;
    end; //if orPatients
  end //if blnOnly...
  else if pgPages.ActivePage = tbPatEnter then
  begin
      //Does this patient already exist?
      { TODO -oHerb -c508 : Change ORDateTime to VCL TDateTimePicker }
      { TODO -oHerb -cSACC : Change prefix txt to edt }
//      if AddManualPatient(txtName.Text,txtSSN.Text,ordDOB.DateText) = True then
    if AddManualPatient(edtName.Text, edtSSN.Text, DateToStr(ordDOB.Date)) = True then
      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('New Patient Added');
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar('New Patient Added'), 'Error', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmGetPat.Handle, PChar('New Patient Added'), 'Error', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : my booboo - title should not have been error since it returned true }
//      MessageBox( self.Handle, PChar('New Patient Added'), 'Error', MB_OK);
      MessageBox( self.Handle, PChar('New Patient Added'), 'Add Patient', MB_OK);
  end
  else if pgPages.ActivePage = tbPersList then
  begin
      //Show our progress bar?
    if orPatList.Items.Count > 0 then
    begin
          //Yes
      pgList.Visible := True;
      pgList.Position := 0;
      pgList.Max := orPatList.Items.Count - 1;
    end;



    { TODO -oHerb -cModification : DO THE LOOP FOR SENSITIVE PATIENTS LAST }

     for iPass := 1 to 2  do
      begin

           //Loop through the checked items
        for iPat := 0 to orPatList.Items.Count - 1 do
          begin
            //Update Status
            pgList.Position := iPat;



        { TODO -oHerb -cModification : Get the Sensitive Patients last }
  //      if orPatList.Checked[iPat] = True then

            bSensitive := (Piece(orPatList.Items[iPat],'^',6) = IntToStr(iPass));

            if (orPatList.Checked[iPat] = True) and
              (not  bSensitive) then

              begin
                       //Get the patient ien
                PatientIEN := 0;
                if IsNumeric(Piece(orPatList.Items[iPat], U, 1)) then
                  { TODO -oHerb -cSACC : Brian code review changes }
//                  PatientIEN := StrToInt(Piece(orPatList.Items[iPat], U, 1));
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//                  PatientIEN := StrToIntDef(Piece(orPatList.Items[iPat], U, 1) ,0);
                  PatientIEN := StrToInt64Def(Piece(orPatList.Items[iPat], U, 1) ,0);

                       //And name
                PatName := Piece(orPatList.Items[iPat], U, 2);

                       //Have one?
                if PatientIEN > 0 then
                  begin
                             //Secure record?
                    { TODO -oHerb -cSACC : Brian code review changes }
//                    blnSelectedSecure := Boolean(Piece(orPatList.Items[iPat], U, 6) = '1');
                    blnSelectedSecure := Piece(orPatList.Items[iPat], U, 6) = '1';
                    iSec := AddPatient(PatientIEN, blnSelectedSecure, 'Patient: ' + PatName, True);
                                //Cancel?
                    if iSec = -1 then
                      begin
                        blnDisClose := False;
                        btnClose.Enabled := True;
                        btnBack.Enabled := True;
                        pgList.Visible := False;
                        Exit;
                      end;
                      //Uncheck
                      orPatList.Checked[iPat] := False;
                  end; //if PatientIEN
              end; //if orPatList.Checked
              //Allow update of GUI elements
              Application.ProcessMessages();
          end; //for iPat


  end;




        //Done
//    GetScreenReader.Speak('Patient(s) Retrieved'); // below should have fixed this  -oHerb -c508
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Patient(s) Retrieved');
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(0, PChar('Patient(s) Retrieved'), 'Informational', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmGetPat.Handle, PChar('Patient(s) Retrieved'), 'Informational', MB_OK);
    MessageBox( self.Handle, PChar('Patient(s) Retrieved'), 'Informational', MB_OK);


  end;
    //Health summary?
  if (iCount > 0) and (RetrieveHS = False) then
      { TODO -oHerb -c508 : MessageDlg needs to be changed to MessageBox per Brian }
//      MessageDlg('Health Summaries were not retrieved' + CRLF + CRLF + 'MED still contains any prior Health Summaries for retrieved patient(s) but the information is out of date',mtWarning,[mbOK],0);
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(Handle, PChar('Health Summaries were not retrieved' + CRLF + CRLF + 'MED still contains any prior Health Summaries for retrieved patient(s) but the information is out of date'), 'Health Summaries were not retrieved', MB_ICONWARNING or MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmGetPat.Handle, PChar('Health Summaries were not retrieved' + CRLF + CRLF + 'MED still contains any prior Health Summaries for retrieved patient(s) but the information is out of date'), 'Health Summaries were not retrieved', MB_ICONWARNING or MB_OK);
    MessageBox( self.Handle, PChar('Health Summaries were not retrieved' + CRLF + CRLF + 'MED still contains any prior Health Summaries for retrieved patient(s) but the information is out of date'), 'Health Summaries were not retrieved', MB_ICONWARNING or MB_OK);

    //Reenable
  blnDisClose := False;
  btnClose.Enabled := True;
  btnBack.Enabled := True;
  PersListRetButton();
  pgList.Visible := False;
end;

function TfrmGetPat.AddManualPatient(Name: string; SSN: string; DOB: string): Boolean;
var
  { TODO -oherb -ccIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  iNewDFN: Integer;
  iNewDFN: INT64;

  ptNew: TPatRecord;
  strSSn: string;
  { TODO -oHerb -cSACC : ptNew needs to be freed after use per Brian }
  ptSaved: Boolean;

begin
  //Default
  Result := False;

  strSSN := TrimNonNumeric(SSN);
  //Does this patient already exist?
  if GetCount('Patients', 'ptSSN = ''' + strSSN + '''') > 0 then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('A patient with this Social Security Number already exists in the MED database');
    { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//    MessageBox(0, PChar('A patient with this Social Security Number already exists in the MED database'), 'Informational', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//    MessageBox( frmGetPat.Handle, PChar('A patient with this Social Security Number already exists in the MED database'), 'Informational', MB_OK);
    MessageBox( self.Handle, PChar('A patient with this Social Security Number already exists in the MED database'), 'Informational', MB_OK);
    Exit;
  end;

  //Get our new ID
  iNewDFN := GetNextManualID();
  if iNewDFN > 0 then Exit;
  //Create our patient
  ptNew := TPatRecord.Create();

  { TODO -oHerb -cSACC : ptNew needs to be freed after use per Brian }
  try
    ptNew.DFN := iNewDFN;
    ptNew.Name := Name;
    ptNew.SSN := strSSN;
    ptNew.DOB := DOB;
    //Flag that this is client created
    ptNew.ClientAdded := True;
    //And that it needs to be saved
    ptSaved := ptNew.SavePatient;
  finally
    FreeAndNil(ptNew);
  end;
//  Result := ptNew.SavePatient;
  Result := ptSaved;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function TfrmGetPat.AddPatient(PatientIEN: Integer; IsSecure: Boolean; Message: string; IsMultiple: Boolean): Integer;
function TfrmGetPat.AddPatient(PatientIEN: INT64; IsSecure: Boolean; Message: string; IsMultiple: Boolean): Integer;
var
  tsPat: TStrings;
  patImp: TPatRecord;
begin
  //Is the patient secure?
  if IsSecure then
  begin
    Result := AccessRecord(PatientIEN, Message, IsMultiple);
    if Result <> 1 then Exit;
  end;

  //Create the patient item
  patImp := TPatRecord.Create();

  { TODO -oHerb -cSACC : patImp needs to be in a Try/Finally block per Brian }
  try
    if assigned(patImp) then
    begin
      { TODO -oHerb -cBetaTest :
If broker call fails due to Health Summary it fails to return patient.
If it fails use try/except and recall getpatient without HS call. }
      try
        tsPat := GetPatientData(PatientIEN, True, RetrieveHS);
      except on E: Exception do
          tsPat := GetPatientData(PatientIEN, True, False);
      end;
      if patImp.SetPatData(tsPat[0]) then
      begin
            //Health summary?
        if tsPat.Count > 1 then
        begin
              //Yes.  Remove the first line and then set
          tsPat.Delete(0);
          patImp.HealthSumm := tsPat.Text;
        end;
          //Save
        patImp.SavePatient();
//          end
            { TODO -oHerb -cSACC : moved the FreeAndNil to finally block }
      end;
//        else
//          begin
            // Release
//            FreeAndNil(patImp);
//          end;
    end;
  finally
    FreeAndNil(patImp);
  end;
  //Done
  Result := 1;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function TfrmGetPat.AccessRecord(PatientIEN: Integer; Message: string; IsMultiple: Boolean): Integer;
function TfrmGetPat.AccessRecord(PatientIEN: INT64; Message: string; IsMultiple: Boolean): Integer;
var
  intRes, intAcc: Integer;
begin
  //Default
  Result := 0;

  //Init
  CleanBroker;

  //Set Broker information
      //Proc
  rpcBroker.RemoteProcedure := 'DG SENSITIVE RECORD ACCESS';
      //Params
         //IEN
  rpcBroker.Param[0].PType := literal;
  rpcBroker.Param[0].Value := IntToStr(PatientIEN);
         //Message
  rpcBroker.Param[1].PType := literal;
  rpcBroker.Param[1].Value := '1';
      //Exec
  CallBroker();

    //What are our results?
  if rpcBroker.Results.Count = 0 then Exit;
  if rpcBroker.Results.Text = '' then Exit;
  if not IsNumeric(rpcBroker.Results[0]) then Exit;
  intAcc := StrToInt(rpcBroker.Results[0]);
  if intAcc in [3..4] then Exit;

    //Remove the leading item
  rpcBroker.Results.Delete(0);

    //Show the dialog
      //Pad message?
  if Message <> '' then Message := Message + CRLF + CRLF;
      //Allow Access?
  if intAcc in [1..2] then
  begin
          //Ask the user what they want to do?
    if IsMultiple then
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      intRes := MessageBox(Self.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to skip this record and Cancel to quit processing any more records'), 'Restricted Record', MB_YESNOCANCEL or MB_ICONEXCLAMATION)
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      intRes := MessageBox( frmGetPat.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to skip this record and Cancel to quit processing any more records'), 'Restricted Record', MB_YESNOCANCEL or MB_ICONEXCLAMATION)
      intRes := MessageBox( self.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to skip this record and Cancel to quit processing any more records'), 'Restricted Record', MB_YESNOCANCEL or MB_ICONEXCLAMATION)
    else
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      intRes := MessageBox(Self.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to cancel'), 'Restricted Record', MB_YESNO or MB_ICONEXCLAMATION);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      intRes := MessageBox( frmGetPat.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to cancel'), 'Restricted Record', MB_YESNO or MB_ICONEXCLAMATION);
      intRes := MessageBox( self.Handle, PChar(Message + rpcBroker.Results.Text + CRLF + CRLF + 'Select Yes to Access the record, No to cancel'), 'Restricted Record', MB_YESNO or MB_ICONEXCLAMATION);
    case intRes of
      IDCANCEL:
        begin
          Result := -1;
          Exit;
        end;
      IDNO:
        begin
          Exit;
        end;
    end;
  end;

    //Log a bulletin?
  if intAcc > 0 then
  begin
      //Clear
    CleanBroker;
         //Execute the RPC
            //Proc
    rpcBroker.RemoteProcedure := 'DG SENSITIVE RECORD BULLETIN';
            //Params
               //IEN
    rpcBroker.Param[0].PType := literal;
    rpcBroker.Param[0].Value := IntToStr(PatientIEN);
            //Exec
    CallBroker();
        //Expected results?
    if rpcBroker.Results.Count = 0 then Exit; //No.  Don't allow access since log can't be generated
    if not IsNumeric(rpcBroker.Results[0]) then Exit; //Same as above
    if StrToInt(rpcBroker.Results[0]) <> 1 then Exit;
  end;

    //Results
  Result := 1;
end;

procedure TfrmGetPat.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if blnDisClose then CanClose := False;
end;

procedure TfrmGetPat.btnSelPatClick(Sender: TObject);
begin
  ChangePage(tbPatSel);
end;

procedure TfrmGetPat.orPatientsNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  orPatients.ForDataUse(SubSetOfPatients(StartFrom, Direction));
end;

procedure TfrmGetPat.GetLast5(Dest: TStrings; const Last5: string);
var
  i: Integer;
  x, ADate, AnSSN: string;
begin
  //Prepare
  CleanBroker();
    { TODO -oAndrew -cTIU Namespace : Conversion to TIU Namespace }
//    rpcBroker.RemoteProcedure := 'ABQMED LAST5';
  rpcBroker.RemoteProcedure := 'TIU MED LAST5';
  //Params
    //Last5
  rpcBroker.Param[0].PType := literal;
  rpcBroker.Param[0].Value := UpperCase(Last5);
  //Invoke
  CallBroker();
  //Sort and change format
  SortByPiece(TStringList(rpcBroker.Results), U, 2);
  with rpcBroker do for i := 0 to Results.Count - 1 do
    begin
      x := Results[i];
      ADate := Piece(x, U, 3);
      AnSSN := Piece(x, U, 4);
      ADate := FormatFMDateTimeStr('mmm d, yyyy', ADate);
      AnSSN := FormatSSN(AnSSN);
      SetPiece(x, U, 2, Piece(x, U, 2) + '   ' + AnSSN + '   ' + ADate);
      Results[i] := x;
    end;
  MixedCaseList(rpcBroker.Results);
  Dest.Assign(rpcBroker.Results);
end;

procedure TfrmGetPat.orPatientsKeyPause(Sender: TObject);
var
  strName, strSSN: string;
begin
  //Matching Last5?
  GetNameSocFormat(orPatients.Text, strName, strSSN);
  if strName <> '' then
  begin
      //Clear the data
    ClearPatientData();
      //Show our listing of matching patients
    GetLast5(orPatients.Items, orPatients.Text);
      //Short count?
    if orPatients.ShortCount > 0 then
    begin
      orPatients.Items.Add(LLS_LINE);
      orPatients.Items.Add(LLS_SPACE);
    end;
      //And our list
    orPatients.InitLongList('');
      //Done
    Exit;
  end;
end;

procedure TfrmGetPat.ordDOBChange(Sender: TObject);
begin
{ TODO -oHerb -c508 : Change ORDateTime to VCL TDateTimePicker }
{ TODO -oHerb -c508 : Add GetScreenReader.Speak(DateToStr(ordDOB.Date)); }
  GetScreenReader.Speak(DateToStr(ordDOB.Date));
  UpdatePatientGUI();
end;

procedure TfrmGetPat.orPatientsClick(Sender: TObject);
begin
  //Clear
  ClearPatientData();

  //Disable
  btnRetrieve.Enabled := False;

  //Get/Show the Data
  if orPatients.ItemIEN > 0 then
  begin
      //Show the data
    ShowPatientData(GetPatientData(orPatients.ItemIEN, false, false)[0]);
      //Enable
    btnRetrieve.Enabled := True;
  end;
end;

procedure TfrmGetPat.btnAddNewClick(Sender: TObject);
begin
  ChangePage(tbPatEnter);
  GetScreenReader.Speak('Manual Patient Entry, Name:');
end;

procedure TfrmGetpat.InitPatEnter();
begin
      { TODO -oHerb -cSACC : Change prefix txt to edt }
  edtName.Text := '';
      { TODO -oHerb -c508 : Change ORDateTime to VCL TDateTimePicker }
      //  ordDOB.Month := 0; ordDOB.Day := 0; ordDOB.Year := 0;
  ordDOB.Date := 0;
      { TODO -oHerb -cSACC : Change prefix txt to edt }
  edtSSN.Text := '';
end;

procedure TfrmGetPat.tbPatEnterEnter(Sender: TObject);
begin
  { TODO -oHerb -c508 : Replace the ToolBar/ToolButton with a Panel and Button }
//  GetScreenReader.Speak('Enter the Patient''s Name:');
end;

procedure TfrmGetPat.edtNameChange(Sender: TObject);
begin
  UpdatePatientGUI();
end;

procedure TfrmGetPat.edtSSNChange(Sender: TObject);
begin
  UpdatePatientGUI();
end;

procedure TfrmGetPat.orSexChange(Sender: TObject);
begin
  UpdatePatientGUI();
end;

procedure TfrmGetPat.UpdatePatientGUI();
var
  strName, strSSN, strDOB: string;
  blnValid: Boolean;
begin
  //Default to "yes"
  blnValid := True;

  //Ensure we're in the write "page"
  if pgPages.ActivePage <> tbPatEnter then Exit;

  //All of the required fields entered and valid?
    //Name
    { TODO -oHerb -cSACC : Change prefix txt to edt }
  strName := Trim(edtName.Text);
  if strName = '' then blnValid := False;

    //SSN
    { TODO -oHerb -cSACC : Change prefix txt to edt }
  strSSN := TrimNonNumeric(edtSSN.Text);
  if Length(strSSN) <> 9 then blnValid := False;

    //Date of Birth
    { TODO -oHerb -c508 : Change ORDateTime to VCL TDateTimePicker }
//    strDOB := Trim(ordDOB.DateText);
  strDOB := Trim(DateToStr(ordDOB.Date));
  if strDOB = '' then blnValid := False;

  //Valid?
  btnRetrieve.Enabled := blnValid;

end;

procedure TfrmGetPat.orSexExit(Sender: TObject);
begin
  UpdatePatientGUI;
end;

procedure TfrmGetPat.orPatientsDblClick(Sender: TObject);
begin
  //Click
  if btnRetrieve.Enabled = True then
    btnRetrieveClick(Self);
end;

end.
