unit fPtSel;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORCtrls, uCore, uPatient, ORFn, {*reenable:hh_funcs, } ExtCtrls, fTestData, uDB,
  VA508AccessibilityManager;

type
  TfrmSelPatient = class(TForm)
    cmbPatients: TORComboBox;
    btnOK: TButton;
    btnCancel: TButton;
    gbPat: TGroupBox;
    btnRetPatList: TButton;
    tmrCheckSSN: TTimer;
    btnDemoAddPat: TButton;
    btnDemoDelPatient: TButton;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    lblName: TStaticText;
    lblSSN: TStaticText;
    lblDOB: TStaticText;
    lblSex: TStaticText;
    procedure cmbPatientsChange(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure SetPatData(patRec: TPatRecord);
    procedure cmbPatientsDblClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure cmbPatientsKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnRetPatListClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tmrCheckSSNTimer(Sender: TObject);
    procedure btnDemoAddPatClick(Sender: TObject);
    procedure btnDemoDelPatientClick(Sender: TObject);
  private
    blnCloseOK: boolean;
    preSelIdx: integer;
    patSelected: TPatRecord;
    procedure CreateList(presel: TPatRecordArr; aftsel: TPatRecordArr; Detailed: boolean);
    function FindMatchingPatient(name: string; soc: string): TPatRecordArr;
    procedure CheckSocial();
  public
    procedure SetPatList(list: TPatRecordArr);
  end;

var
  frmSelPatient: TfrmSelPatient;
  preList: TPatRecordArr;
  patList: TPatRecordArr;
implementation

uses
  VA508AccessibilityRouter;

{$R *.DFM}

procedure TfrmSelPatient.SetPatList(list: TPatRecordArr);
begin
  //Set our patient list
  if not assigned(list) then Exit;
  //Set this as our current list
  patList := list;

  //Add it
  CreateList(preList, patList, false);

  //Determine scrollbars
  cmbPatients.InitLongList('');
end;

procedure TfrmSelPatient.cmbPatientsChange(Sender: TObject);
var
  ptSel: TPatRecord;
begin
  if cmbPatients.ItemIndex > -1 then
  begin
      //Get the patient
    ptSel := TPatRecord(cmbPatients.Items.Objects[cmbPatients.ItemIndex]);
      //Have a patient?
    if not assigned(ptSel) then
    begin
      SetPatData(nil);
      btnOK.Enabled := False;
    end
    else
    begin
            //Enable
      btnOK.Enabled := True;
            //Set it
      SetPatData(ptSel);
    end;
  end
  else
  begin
      //Disable
    btnOK.Enabled := False;
      //Clear
    SetPatData(nil);
  end;
end;

procedure TfrmSelPatient.btnCancelClick(Sender: TObject);
begin
  //Set that the user hasn't selected a patient
  blnCloseOK := False;
  //Quit
  CurrPatient := nil;
  //Set our status
  PatSelStatus := SELPAT_CANCELLED;
  //Close this form
  self.Close;
end;

procedure TfrmSelPatient.SetPatData(patRec: TPatRecord);
begin
  //Assign
  patSelected := PatRec;
  //Clear our labels?
  if assigned(patRec) then
  begin
    btnDemoDelPatient.enabled := true;
        { TODO -oHerb -c508 : lblName, lblSSN, lblDOB, and lblSex changed from TEdit to TStatic Text }
        { TODO : Adding a lbl for the TStaticText did not work with JAWs.  Do not know why but revert back to Shawn's combined caption. }
    lblName.Caption := 'Name:  ' + patRec.Name;
    lblSSN.Caption := 'SSN:  ' + FormatSSN(patRec.SSN);
    lblDOB.Caption := 'DOB:  ' + patRec.DOB;
    if patRec.Sex = 'M' then
      lblSex.Caption := 'Male'
    else if patRec.Sex = 'F' then
      lblSex.Caption := 'Female'
    else
      lblSex.Caption := '';
    lblSex.Caption := 'Sex:  ' + lblSex.Caption;

    GetScreenReader.Speak(lblName.Caption + ', ' + lblSSN.Caption + ', ' + lblDOB.Caption + ', ' + lblSex.Caption);
  end
  else
  begin

    btnDemoDelPatient.enabled := false;
    lblName.Caption := 'Name:  ';
    lblSSN.Caption := 'SSN:  ';
    lblDOB.Caption := 'DOB:  ';
    lblSex.Caption := 'Sex:  ';
  end;
end;

procedure TfrmSelPatient.cmbPatientsDblClick(Sender: TObject);
begin
  //Is the OK button enabled?
  if btnOK.Enabled = True then
    btnOKClick(Sender);
end;

procedure TfrmSelPatient.btnOKClick(Sender: TObject);
begin
  //Set that the user hasn't selected a patient
  blnCloseOK := True;
  //Set the patient
  CurrPatient := patSelected;
  //Get the full data for this patient
  CurrPatient.GetFullData;
  //Set the pre list
  SetLength(preList, 1);
  preList[0] := CurrPatient;
  //Set our status
  PatSelStatus := SELPAT_SELECTED;
  //Close this form
  Self.Close;
end;

procedure TfrmSelPatient.cmbPatientsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  //Disable the timer
  tmrCheckSSN.Enabled := False;

  //Enable the timer?
  if self.cmbPatients.SelLength = 0 then
    tmrCheckSSN.Enabled := True; //Yes.

  //What key?
  if Key = 13 then
  begin
        //Check for a social
    CheckSocial();
  end;
end;

//Check for a patient with the matching format

procedure TfrmSelPatient.CheckSocial();
var
  PtName, PtSoc: string;
begin
  if btnOK.Enabled = True then
    btnOKClick(Self)
  else
  begin
      //Last Letter-Last 4 format? e.g. E0001
    GetNameSocFormat(cmbPatients.Text, PtName, PtSoc);
      //Have anything?
    if PtName <> '' then
    begin
            //Find any patients that match
      SetLength(preList, 0);
      preList := FindMatchingPatient(PtName, PtSoc);
            //Have one?
      if assigned(preList) then
        CreateList(preList, patList, true);
    end;
  end;
end;

//Create a list with a possible dividing line.
//This can be last patient, search criteria, etc. for the preselection
//and all patients for the aftselection

procedure TfrmSelPatient.CreateList(presel: TPatRecordArr; aftsel: TPatRecordArr; Detailed: boolean);
var
  i, Idx: integer;
begin
  //Clear
  cmbPatients.Clear;
  //Default our index
  preSelIdx := -1;
  //Heading?
  if assigned(presel) then
      //Set our index
    preSelIdx := High(presel);
      //Get the items
  with cmbPatients do
  begin
            //Clear our text
    Text := '';
            //Add our items
    for i := Low(presel) to High(presel) do
    begin
      if assigned(presel[i]) then
                    //Detailed output?
        if Detailed then
        begin
          Idx := Items.Add('p^' + presel[i].Name + '  ' + presel[i].SSN + '  ' + presel[i].DOB);
          Items.Objects[Idx] := presel[i];
        end
        else
        begin
          Idx := Items.Add('a^' + presel[i].Name);
          Items.Objects[Idx] := presel[i];
        end;
    end;
            //Now add our line
    Items.Add(LLS_LINE);
  end;

    //Aft?
  if assigned(aftsel) then
    with cmbPatients do
    begin
            //Add our items
      for i := Low(patList) to High(patList) do
      begin
        Idx := Items.Add('a^' + patList[i].Name);
        Items.Objects[Idx] := patList[i];
      end;
    end;
end;

function TfrmSelPatient.FindMatchingPatient(name: string; soc: string): TPatRecordArr;
var
  patMatch: TPatRecordArr;
  PtName, PtSoc: string;
  i, p: integer;
  patRecord: TPatRecord;
begin
  //Default to nil
  patMatch := nil;

  //Find matches
  for p := 0 to cmbPatients.Items.Count - 1 do
  begin
            //Get the values
    if assigned(cmbPatients.Items.Objects[p]) then
    begin
              //Get the record
      patRecord := TPatRecord(cmbPatients.Items.Objects[p]);
      PtName := patRecord.Name;
      PtSoc := patRecord.SSN;
                  //Now truncate them
      PtName := copy(PtName, 1, 1);
      PtSoc := copy(PtSoc, Length(PtSoc) - 3, 4);
                  //Match?
      if (PtName = name) and (PtSoc = soc) and (Piece(cmbPatients.Items[p], '^', 1) <> 'p') then
      begin
                           //Get the length
        if (not assigned(patMatch)) then
          i := 0
        else
          i := Length(patMatch);
                           //Now resize our array and add the record item
        SetLength(patMatch, i + 1);
        patMatch[i] := patRecord;
      end;
    end;
  end;

  //Return it
  Result := patMatch;
end;

procedure TfrmSelPatient.btnRetPatListClick(Sender: TObject);
begin
  //Quit
  CurrPatient := nil;
  blnCloseOK := True;
  //Set our status
  PatSelStatus := SELPAT_GETPATS;
  //Close this form
  self.Close;
end;

procedure TfrmSelPatient.FormCreate(Sender: TObject);
var
  Enum: TComponentEnumerator;
begin
  {
  blj 9 June 2009 - 508
  We've changed the patient name, DOB, and SSN labels from labels to static
  text components.  Now, we need to go through and see if a screen reader is
  running.  If it is, then we need to enable the tab stops for the static text
  components.
  }

    lblName.TabStop := ScreenReaderSystemActive;  
    lblSSN.TabStop := ScreenReaderSystemActive;  
    lblDOB.TabStop := ScreenReaderSystemActive;  
    lblSex.TabStop := ScreenReaderSystemActive;   

  Enum := GetEnumerator;
  try
    while Enum.MoveNext do
      if Enum.Current is TEdit then
        with Enum.Current as TEdit do
          TabStop := ScreenReaderSystemActive;
  finally
    FreeAndNil(Enum);
  end;


  //Can we add a patient (Demo mode only)
  btnDemoAddPat.visible := blnIsDemo;
  btnDemoDelPatient.visible := blnIsDemo;
  //Can we retrieve the patient list?
  Self.btnRetPatList.Enabled := not blnGettingPatList;
end;

procedure TfrmSelPatient.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //Disable the timer
  Self.tmrCheckSSN.Enabled := False;
  //Valid?
  if blnCloseOK = False then
  begin
        //Remove any patient reference
    CurrPatient := nil;
        //Set our status
    PatSelStatus := SELPAT_CANCELLED;
  end;
end;

procedure TfrmSelPatient.tmrCheckSSNTimer(Sender: TObject);
begin
  //Selection?
  if cmbPatients.SelLength = 0 then
    CheckSocial();

  //Disable
  tmrCheckSSN.Enabled := False;
end;

procedure TfrmSelPatient.btnDemoAddPatClick(Sender: TObject);
var
  frmAdd: TfrmTestData;
begin
  //Show the add patient form
  frmAdd := TfrmTestData.Create(Self);
  frmAdd.ShowModal;
  //Quit
  CurrPatient := nil;
  blnCloseOK := True;
  //Set our status
  PatSelStatus := SELPAT_RESELECT;
  //Close this form
  self.Close;
end;

procedure TfrmSelPatient.btnDemoDelPatientClick(Sender: TObject);
begin
  //Delete the current patient
  DeletePatient(patSelected.DFN);
  //Quit
  CurrPatient := nil;
  blnCloseOK := True;
  //Set our status
  PatSelStatus := SELPAT_RESELECT;
  //Close this form
  self.Close;
end;

end.
