{ ******************************************************* }
{                                                         }
{          VA 508 Manager - Translation Library           }
{                                                         }
{    Unit used to translate class types to readable text  }
{                                                         }
{           Translations meant to be generic              }
{                                                         }
{ ******************************************************* }

unit VA508TranslateDictionary;

interface

uses
  Generics.Collections,
  VCL.Controls,
  System.SysUtils;

type

  TVA508AccessibilityTranslation = Class(TObject)
  private
    Class Var DictionaryObj: TDictionary<String, String>;
    Class Procedure InitDictionaryObj;
    class function GetTranslationDictionary
      : TDictionary<String, String>; static;
  public
    Class function TranslateClassName(aWinControl: TWinControl; aDefault: String = ''): String;
    Class Procedure AddOrSetTranslation(ClassName, TranslationText: String);
    Class property TranslationDictionary: TDictionary<String, String>
      Read GetTranslationDictionary;
  End;

implementation


Class Procedure TVA508AccessibilityTranslation.InitDictionaryObj;
begin
  If not Assigned(DictionaryObj) then
    DictionaryObj := TDictionary<String, String>.Create;

  DictionaryObj.Clear;
  DictionaryObj.Add('TAnimate', 'Animation');
  DictionaryObj.Add('TBitBtn', 'Button');
  DictionaryObj.Add('TButton', 'Button');
  DictionaryObj.Add('TCaptionCheckListBox', 'Check List Box');
  DictionaryObj.Add('TCaptionComboBox', 'Combo Box');
  DictionaryObj.Add('TCaptionEdit', 'Edit Box');
  DictionaryObj.Add('TCaptionListBox', 'List Box');
  DictionaryObj.Add('TCaptionListView', 'Lit View');
  DictionaryObj.Add('TCaptionMemo', 'Memo');
  DictionaryObj.Add('TCaptionRichEdit', 'Rich Edit');
  DictionaryObj.Add('TCaptionStringGrid', 'String Grid');
  DictionaryObj.Add('TCaptionTreeView', 'Tree View');
  DictionaryObj.Add('TChart', 'Chart');
  DictionaryObj.Add('TCheckBox', 'Check Box');
  DictionaryObj.Add('TCheckListBox', 'Check List Box');
  DictionaryObj.Add('TColorBox', 'Color Box');
  DictionaryObj.Add('TComboBox', 'Combo Box');
  DictionaryObj.Add('TCopyPasteDetails', 'Paste Details');
  DictionaryObj.Add('TDBGrid', 'Grid');
  DictionaryObj.Add('TEdit', 'Edit Box');
  DictionaryObj.Add('TGridPanel', 'Grid Panel');
  DictionaryObj.Add('TGroupBox', 'Group Box');
  DictionaryObj.Add('THeaderControl', 'Header Control');
  DictionaryObj.Add('TKeyClickPanel', 'Key Panel');
  DictionaryObj.Add('TKeyClickRadioGroup', 'Key Radio Group Box');
  DictionaryObj.Add('TLabeledEdit', 'Edit Box');
  DictionaryObj.Add('TListBox', 'List Box');
  DictionaryObj.Add('TListView', 'List View');
  DictionaryObj.Add('TMaskEdit', 'Edit Box');
  DictionaryObj.Add('TMemo', 'Memo');
  DictionaryObj.Add('TMonthCalendar', 'Calendar');
  DictionaryObj.Add('TORAlignEdit', 'Edit Box');
  DictionaryObj.Add('TORAlignButton', 'Button');
  DictionaryObj.Add('TORAutoPanel', 'Panel');
  DictionaryObj.Add('TORCheckBox', 'Check Box');
  DictionaryObj.Add('TORCheckComboBox', 'Check Combo Box');
  DictionaryObj.Add('TORComboBox', 'Combo Box');
  DictionaryObj.Add('TORDateCombo', 'Date Combo Box');
  DictionaryObj.Add('TORDateBox', 'Date Box');
  DictionaryObj.Add('TORListBox', 'List Box');
  DictionaryObj.Add('TORStaticText', 'Text');
  DictionaryObj.Add('TORTreeView', 'Tree View');
  DictionaryObj.Add('TPageControl', 'Page Control');
  DictionaryObj.Add('TPanel', 'Panel');
  DictionaryObj.Add('TProgressBar', 'Progress Bar');
  DictionaryObj.Add('TRadioButton', 'Radio Button');
  DictionaryObj.Add('TRadioGroup', 'Radio Group');
  DictionaryObj.Add('TRichEdit', 'Rich Edit');
  DictionaryObj.Add('TScrollBox', 'Scroll Box');
  DictionaryObj.Add('TSpeedButton', 'Button');
  DictionaryObj.Add('TSpinEdit', 'Spin Edit');
  DictionaryObj.Add('TSplitter', 'Splitter');
  DictionaryObj.Add('TStaticText', 'Text');
  DictionaryObj.Add('TStatusBar', 'Status Bar');
  DictionaryObj.Add('TStringGrid', 'String Grid');
  DictionaryObj.Add('TTabControl', 'Tab Control');
  DictionaryObj.Add('TTabSheet', 'Tab Sheet');
  DictionaryObj.Add('TToolBar', 'Tool Bar');
  DictionaryObj.Add('TUpDown', 'Up / Down Button');
  DictionaryObj.Add('TVA508StaticText', 'Text');
  DictionaryObj.Add('TWebBrowser', 'Web Browser');
  DictionaryObj.TrimExcess;
end;

class function TVA508AccessibilityTranslation.GetTranslationDictionary
  : TDictionary<String, String>;
begin
  If not Assigned(DictionaryObj) then
    TVA508AccessibilityTranslation.InitDictionaryObj;

  Result := DictionaryObj;
end;

class procedure TVA508AccessibilityTranslation.AddOrSetTranslation(ClassName,
  TranslationText: String);
begin
  TranslationDictionary.AddOrSetValue(ClassName, TranslationText);
end;

class function TVA508AccessibilityTranslation.TranslateClassName(
  aWinControl: TWinControl; aDefault: String = ''): String;
var
  ClassRef: TClass;
begin
  Result := '';
  ClassRef := aWinControl.ClassType;
  while (ClassRef <> nil) and (ClassRef <> TWinControl) and (Result = '') do
  begin
    TranslationDictionary.TryGetValue(ClassRef.ClassName, Result);
    ClassRef := ClassRef.ClassParent;
  end;
  If Trim(Result) = '' then
    Result := aDefault;
end;

Initialization

Finalization

FreeAndNil(TVA508AccessibilityTranslation.TranslationDictionary);

end.
