unit UInitializeRPCCache;
////////////////////////////////////////////////////////////////////////////////
///  Call TInitializeRPCCache.Execute to start caching using settings from
///  the ORRPC CACHE remote procedure call.
////////////////////////////////////////////////////////////////////////////////
interface
uses
  URPCCache;

type
  TInitializeRPCCache = class(TObject)
  strict private
    class procedure DoNewContext(Sender: TRPCCacheList; const AContext: string);
  public
    class procedure Execute;
  end;

implementation
uses
  ORNet,
  System.Classes,
  System.SysUtils;

class procedure TInitializeRPCCache.DoNewContext(Sender: TRPCCacheList;
  const AContext: string);
var
  AStringList: TStringList;
begin
  AStringList := TStringList.Create;
  try
    if CallVista('ORRPC CACHE', [AContext], AStringList) then
      Sender.Initialize(AStringList.Text);
  finally
    FreeAndNil(AStringList);
  end;
end;

class procedure TInitializeRPCCache.Execute;
begin
  RPCCache.OnNewContext := TInitializeRPCCache.DoNewContext;
end;

end.
