unit VAShared.RttiUtils;

interface

uses
  System.Rtti, System.TypInfo;

function GetRttiField(ATypeInf: PTypeInfo; AName: string; AParentClassName: string = ''): TRttiField;

function GetRttiProperty(ATypeInf: PTypeInfo; AName: string; AParentClassName: string = ''): TRttiProperty;

implementation

uses
  System.SysUtils;

function GetRttiField(ATypeInf: PTypeInfo; AName: string; AParentClassName: string = ''): TRttiField;
var
  Ctx: TRttiContext;
  LType: TRttiType;
begin
  Ctx := TRttiContext.Create();
  try
    LType := Ctx.GetType(ATypeInf);
    for Result in LType.GetFields do
      if (CompareText(Result.Name, AName) = 0) then
      begin
        if AParentClassName = '' then
          Exit
        else if Result.Parent.Name = AParentClassName then
          Exit;
      end;
    Result := nil;
  finally
    Ctx.Free;
  end;
end;

function GetRttiProperty(ATypeInf: PTypeInfo; AName: string; AParentClassName: string = ''): TRttiProperty;
var
  Ctx: TRttiContext;
  LType: TRttiType;
begin
  Ctx := TRttiContext.Create();
  try
    LType := Ctx.GetType(ATypeInf);
    for Result in LType.GetProperties do
      if (CompareText(Result.Name, AName) = 0) and ((AParentClassName = '') or
        (Result.Parent.Name = AParentClassName)) then
        Exit;
    Result := nil;
  finally
    Ctx.Free;
  end;
end;

end.
