unit uDB;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses Forms, ComObj, Dialogs, uCore,Windows, SysUtils, uNote, classes, ORFn, uPatient,
  comctrls, fGetPatList, Trpcb, clipbrd,
     { TODO -oHerb -c508 conversion : Add Variants to uses clause for VarType }
  Variants;


function DBConnect(MDB: string): boolean;
function DBClose(Compact: boolean): boolean;
function GetPatients(): OleVariant;
function GetPatientsArr(): TPatRecordArr;
function ExecuteQuery(query: string): boolean;
function Nz(fld: OleVariant; default: string): string;
function DBBool(blnVal: boolean): string;
function SQLSafe(clean: string): string;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNextManualID(): Integer;
function GetNextManualID(): INT64;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotes(PatientDFN: integer): OleVariant;
function GetNotes(PatientDFN: INT64): OleVariant;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotesArr(PatientDFN: integer): TNoteRecordArr;
function GetNotesArr(PatientDFN: INT64): TNoteRecordArr;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function DeletePatient(WithID: integer): boolean;
function DeletePatient(WithID: INT64): boolean;

function DeleteDaysOldNotes(NumDays: integer): boolean;
function GetCount(TableQuery: string; Where: string): integer;
procedure GetNoteID(ntNote: TNoteRecord);
function FieldExists(rst: OleVariant; name: string): boolean;
function GetPatHealthSumm(Patient: TPatRecord): string;
function GetPatScratchPad(Patient: TPatRecord): string;
function DeletePatsWithNoNotes(NumDays: integer): boolean;
function DeleteHealthSummFiles(): boolean;

{ TODO -oHerb -cIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function DeleteHealthSummFile(ForPatIEN: Integer): boolean;
function DeleteHealthSummFile(ForPatIEN: INT64): boolean;

function GetPatientsAndNotesSummary(): string;
function GetDBError(): string;
function ReadFile(fileName: string): string;
function WriteFile(fileName, contents: string): boolean;
function GetFileSizeMB(fileName: string): integer;
function SaveSettings(): boolean;
procedure GetSettings();
Procedure TIU315DBFix;

implementation
uses
 Data.DB;

var
  con: OleVariant;
  CurrDB: string;

function GetDBError(): string;
begin
  //Default
  Result := '';
  //Have a connection?
  if not VarType(con) = VarDispatch then
    Exit;
  //Get the Description of the last error
  Result := con.Description;
end;

{Retrieve the NoteID in the database for a given Note}

procedure GetNoteID(ntNote: TNoteRecord);
var
  rst: OleVariant;
begin
  try
    //Have a note?
    if not assigned(ntNote) then
      Exit;

    //Have a connection?
    if not VarType(con) = VarDispatch then
      Exit;

    //Connected?
    if not (con.state = 1) then
      Exit;

    //Query our recordset

    { TODO -oherb -cIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    rst := con.Execute('SELECT MAX(ntRfnbr) as NoteID FROM [Notes] WHERE ntPatnbr = ' + IntToStr(ntNote.ParentDFN) + ' AND ntNoteTitle = ''' + SQLSafe(ntNote.Title) + ''' and ntCaption = ''' + SQLSafe(ntNote.Caption) + '''', EmptyParam, 0);
    rst := con.Execute('SELECT MAX(ntRfnbr) as NoteID FROM [Notes] WHERE ntPatnbr = ''' + IntToStr(ntNote.ParentDFN) + ''' AND ntNoteTitle = ''' + SQLSafe(ntNote.Title) + ''' and ntCaption = ''' + SQLSafe(ntNote.Caption) + '''', EmptyParam, 0);

    //Have any?
    if not VarType(rst) = VarDispatch then
      exit;

    if rst.EOF and rst.BOF then
      Exit;

    //Get the value
    ntNote.NoteID := rst.Fields['NoteID'];

  except on E: Exception do
    begin
      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('GetNoteID Error:' + E.Message);
      MessageBox(0, PChar('GetNoteID Error:' + E.Message), 'Error', MB_OK);
      Application.HandleException(nil);
    end;

  end;
end;

function ExecuteQuery(query: string): boolean;
begin
  try
    con.Execute(query);
    Result := True; //Query succeeded
  except
    on E: Exception do
    begin
        { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian - could not use Handle }
//        MessageDlg('DB Error:' + E.Message,mtError,[mbOK],0);
      MessageBox(0, PChar('DB Error: ' + E.Message), 'Database Error', MB_ICONERROR or MB_OK);
      Result := False; //Query failed
      Application.HandleException(nil);
    end;
  end;
end;

function GetPatientsAndNotesSummary(): string;
var
  rst: OleVariant;
  tsContents: TStringList;
  patientName, SSN, lastSSN, noteCaption, noteStat: string;
begin
  //Create our Contents list
  tsContents := TStringList.Create();
    { TODO -oHerb -cSQA : tsContents needs to be in a try/finally block - per Brian }
  try // try/finally    tsContents := TStringList.Create();
  //Get our items
    try
      //Get the Patients that have Notes
      rst := con.Execute('SELECT ptName, ptSSN, ntCaption, ntImported FROM Patients, Notes WHERE ptDFN = ntPatNbr ORDER by ptSortIndex, ptSSN, ntImported, ntCreateDate', EmptyParam, 0);

      //Have any?
      if ((not VarType(rst) = VarDispatch) or (rst.EOF and rst.BOF)) then
      begin
        tsContents.Clear;
        tsContents.Add('No Patients with Notes (Pending or Imported)');
        Exit;
      end;

      //Get each item
      while not rst.EOF do
      begin
          //Get the values
        patientName := Nz(rst.Fields['ptName'], '');
        ssn := Nz(rst.Fields['ptSSN'], '');
        noteCaption := Nz(rst.Fields['ntCaption'], '');

         { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//        blnImported := (Nz(rst.Fields['ntImported'], '0') <> '0');
        if (Nz(rst.Fields['ntImported'], 'False') <> 'False') then
          noteStat := 'Imported'
        else
          noteStat := 'Pending';

        //New Patient?
        if ssn <> lastSSN then
        begin
          //Output our Patient's Name
          tsContents.Add('');
          tsContents.Add(patientName);
          tsContents.Add(' ' + ssn.Substring(ssn.Length - 4, 4));
          //Store this
          lastSSN := ssn;
        end; // end if ssn <> lastSSN

        // Status
        tsContents.Add('');
        tsContents.Add(StringOfChar(' ', 25) + noteStat);

        //Now output our note
        tsContents.Add(StringOfChar(' ', 50) + noteCaption);

        //Next record
        rst.MoveNext;
      end; // end while loop
    except
      tsContents.Clear;
      tsContents.Add('No Patients with Notes (Pending or Imported)');
      Exit;
    end; // end try except

  //Return our contents
    Result := tsContents.Text;

  finally // try/finally    tsContents := TStringList.Create();
    //Free our resources
    FreeAndNil(tsContents);
  end; // end try finally  tsContents := TStringList.Create();


end;

function GetPatientsArr(): TPatRecordArr;
var
  rstPat: OleVariant;
  arRec: TPatRecordArr;
  rcNew: TPatRecord;
  tsSort: TStringList;
  i, Idx: integer;
begin
  //Default return
  Result := nil;
  //Get the records
  rstPat := GetPatients();
  //Add our items
  if VarType(rstPat) = VarNull then
    Exit;
  //Get our items
  try
    while (rstPat.EOF = False) do
    begin
          //Create our record
      rcNew := TPatRecord.Create();

          //Populate it
      if rcNew.SetPatData(rstPat) = True then
      begin
                //Get the length
        if (not assigned(arRec)) then
          i := 0
        else
          i := Length(arRec);
                //Now resize our array and add the record item
        SetLength(arRec, i + 1);
        arRec[i] := rcNew;
      end;

          //Next record
      rstPat.MoveNext;
    end;

  //Sort our results
    tsSort := TStringList.Create();
    tsSort.Duplicates := dupAccept; //*SMT Allow Duplicate names
    { TODO -oHerb -cSQA : tsSort needs to be in a try/finally block - per Brian }
    try // try/ finally     tsSort := TStringList.Create();
      tsSort.Sorted := True;
      //Add our items
      for i := Low(arRec) to High(arRec) do
      begin
          //Add it
        Idx := tsSort.Add(arRec[i].Name);
        tsSort.Objects[Idx] := arRec[i];
      end;

      //Release our references and recreate our array from the sorted list
      SetLength(arRec, 0);
      SetLength(arRec, tsSort.Count);

      //Now put the objects back in the proper order

      for i := 0 to tsSort.Count - 1 do
      begin
        //Set it
        arRec[i] := TPatRecord(tsSort.Objects[i]);
      end;

    finally // try/finally tsSort := TStringList.Create();
      //Done
      FreeAndNil(tsSort);
    end; // try/finally tsSort := TStringList.Create();


  //Return our array
    Result := arRec;

  except
    Result := nil;
    Application.HandleException(nil);
  end;

end;

function GetPatients(): OleVariant;
var
  rst: OleVariant;
begin
  //Default value of nil
  Result := VarNull;
  //Have a connection?
  if not VarType(con) = VarDispatch then
    Exit;

  //Connected?
  if not (con.state = 1) then
    Exit;

  //Query our recordset
  try
      //Get the patients
    rst := con.Execute('SELECT ptDFN, ptName, ptDOB, ptSSN, ptSex, ptLastUpdate, ptClientAdded, ptIsSecure FROM [Patients] ORDER BY ptName, ptSSN', EmptyParam, 0);
    //Have any?
    if (VarType(rst) = VarDispatch) or ((not rst.EOF) and (not rst.BOF)) then
      Result := rst;

  except
    on E: Exception do
    begin
          //Show the error
            { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- could not use Handle}
//            MessageDlg('Database Error: ' + E.Message,mtError,[mbOK],0);
      MessageBox(0, PChar('Database Error: ' + E.Message), 'Database Error', MB_ICONERROR or MB_OK);
          //Return nothing
      Result := VarNull;
      Application.HandleException(nil);
    end;
  end;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNextManualID(): Integer;
function GetNextManualID(): INT64;
var
  { TODO -oherb -ccIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
  i: INT64;
begin

  //Get the records
  { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }

 //  I could never get the SQL call to work so we will loop thru the database until
 //  we find a slot to use.  All manually entered patients have negative numbers
 //  so the loop decraments numbers less then 0.  herb 10/9/2009

  i := -1;
  while GetCount('Patients', 'ptDFN = ''' + IntToStr(i) + '''') > 0 do
  begin
    i := i-1;
  end;

  Result := i;

end;


{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotesArr(PatientDFN: integer): TNoteRecordArr;
function GetNotesArr(PatientDFN: INT64): TNoteRecordArr;
var
  rstNt: OleVariant;
  arRec: TNoteRecordArr;
  rcNew: TNoteRecord;
  i: integer;
begin
  //Default return
  Result := nil;
  //Get the records
  rstNt := GetNotes(PatientDFN);
  //Add our items
  if not (VarType(rstNt) = VarDispatch) then
    Exit;
  //Get our items
  while (rstNt.EOF = False) do
  begin
        //Create our record
    rcNew := TNoteRecord.Create(CurrPatient);

        //Populate it
    if rcNew.SetNoteData(rstNt) = True then
    begin
              //Get the length
      if (not assigned(arRec)) then
        i := 0
      else
        i := Length(arRec);

              //Now resize our array and add the record item
      SetLength(arRec, i + 1);
      arRec[i] := rcNew;
    end;

        //Next record
    rstNt.MoveNext;
  end;

  //Return our array
  Result := arRec;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotes(PatientDFN: integer): OleVariant;
function GetNotes(PatientDFN: INT64): OleVariant;
var
  rst: OleVariant;
begin
  //Default value of nil
  Result := VarNull;
  //Have a connection?
  if not VarType(con) = VarDispatch then
    Exit;

  //Connected?
  if not (con.state = 1) then
    Exit;

  //Query our recordset
  try
      //Query

    { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = ' + IntToStr(PatientDFN) + ' Order by ntImported, ntCreateDate', EmptyParam, 0);
{ TODO -oherb -cModification : Change for version 4 to 4a Order the notes in Descending order. }
//    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = ''' + IntToStr(PatientDFN) + ''' Order by ntImported, ntCreateDate', EmptyParam, 0);
    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = ''' + IntToStr(PatientDFN) + ''' Order by ntImported, ntCreateDate DESC ', EmptyParam, 0);

    Result := rst;
     //Have any?
    if not VarType(rst) = VarDispatch then
      Result := VarNull;
    if rst.EOF and rst.BOF then
      Result := VarNull;
  except
    on E: Exception do
    begin
          //Show the error
            { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- could not use Handle}
//            MessageDlg('Database Error: ' + E.Message,mtError,[mbOK],0);
      MessageBox(0, PChar('Database Error: ' + E.Message), 'Database Error', MB_ICONERROR or MB_OK);
          //Return nothing
      Result := VarNull;
      Application.HandleException(nil);
    end;
  end;

end;

function DBConnect(MDB: string): boolean;
begin
  //Default
  Result := False;

  //Have a connection object
  if not (VarType(con) = VarDispatch) then
  begin
    con := CreateOleObject('ADODB.Connection');
        //Still missing?
    if not (VarType(con) = VarDispatch) then
      Exit;
  end;

  //Connect
  try
      //Connect
    con.Open('Provider=Microsoft.Jet.OLEDB.4.0; Data Source=' + MDB + ';', '', '', 0);
      //Set the current database
    CurrDB := MDB;
      //Return connection status
    Result := (con.State = 1);
  except
      //Error
    Result := False;
    Application.HandleException(nil);
  end;
end;

//Similar to Access's Nz function to return a value for a null

function Nz(fld: OleVariant; default: string): string;
begin
  try
    if VarType(fld.value) = varNull then
      Result := default //Null.. return the default
    else
        Result := fld.value; //Return the value itself
  except
    Result := default;
  end;
end;

//Return a string representing the boolean value

function DBBool(blnVal: boolean): string;
begin
  if blnVal then
    Result := 'True'
  else
    Result := 'False';
end;

//Quote strings for sql commands

function SQLSafe(clean: string): string;
begin
    //Replace each instance of ' with ''
  Result := StringReplace(clean, '''', '''''', [rfReplaceAll, rfIgnoreCase]);
end;

//Find notes older than the specified number of days

function DeleteDaysOldNotes(NumDays: integer): boolean;
var
  dtFrom: TDateTime;
  dtDay: TDateTime;
  strQry: string;
begin
  //Calculate the date that is x number of days from today.
    //Calculate a day
  dtDay := EncodeDate(2000, 01, 02) - EncodeDate(2000, 01, 01);
    //Current date minus the number of days
  dtFrom := Date() - (dtDay * NumDays);
    //Create the query
  strQry := 'DELETE from Notes where ntImportDate < #' + DateToStr(dtFrom) + '# and ntImported = TRUE';
    //Execute the query
  Result := ExecuteQuery(strQry);
end;

//Find patients that don't have any notes associated with them and remove them

function DeletePatsWithNoNotes(NumDays: integer): boolean;
var
  dtFrom: TDateTime;
  dtDay: TDateTime;
  rst: OleVariant;

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  patIEN: Integer;
  patIEN: INT64;

begin
  //Calculate a day
  dtDay := EncodeDate(2000, 01, 02) - EncodeDate(2000, 01, 01);
  //Current date minus the number of days
  dtFrom := Date() - (dtDay * NumDays);
  //Run the query
  rst := con.Execute('select ptDFN from Patients where ptDFN not in (select ntPatNbr from Notes) and ptLastUpdate < #' + DateToStr(dtFrom) + '#');
    //Have any?
  if ((not VarType(rst) = VarDispatch) or (rst.EOF and rst.BOF)) then
  begin
    Result := True;
    Exit;
  end;

      //Get each item
  while (rst.EOF = False) do
  begin
            //Get the values
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//    patIEN := StrToInt(Nz(rst.Fields['ptDFN'], '0'));
    patIEN := StrToInt64(Nz(rst.Fields['ptDFN'], '0'));

            //Delete
    if patIEN > 0 then
    begin
      DeletePatient(patIEN);
    end;

            //Next record
    rst.MoveNext;
  end;
    //Done
  Result := True;
end;

//Delete the specified patient

{ TODO -oHerb -cIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function DeletePatient(WithID: integer): boolean;
function DeletePatient(WithID: INT64): boolean;
var
  strQry: string;
begin
  //Create the query

  { TODO -oherb -ccIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  strQry := 'DELETE from Patients where ptDFN =' + IntToStr(WithID);
  strQry := 'DELETE from Patients where ptDFN = ''' + IntToStr(WithID) + '''';

  //Execute the query
  Result := ExecuteQuery(strQry);
  //And clear their health summary
  DeleteHealthSummFile(WithID);
end;

function GetCount(TableQuery: string; Where: string): integer;
var
  rstCnt: OleVariant;
begin
  rstCnt := con.Execute('SELECT Count(*) as Cnt FROM ' + TableQuery + ' WHERE ' + Where);
  if not (VarType(rstCnt) = VarDispatch) then
    Result := -1
  else
  begin
    if rstCnt.EOF and rstCnt.BOF then
      Result := -1
    else
      Result := rstCnt.Fields['Cnt'];
  end;
end;

{Check to see if a field exists}

function FieldExists(rst: OleVariant; name: string): boolean;
var
  strNA: string;
begin
  try
    strNA := rst.Fields[name];
    Result := True;
  except
    Result := False;
  end;
end;

{Get the health summary for the specified patient}

function GetPatHealthSumm(Patient: TPatRecord): string;
begin
  //Default
  Result := '';
  //Open the health summary file for this patient
  Result := ReadFile(AppDataPath + '\db\' + IntToStr(Patient.DFN) + '.hsm');
end;

{Get the scratchpad information for the specified patient}

function GetPatScratchPad(Patient: TPatRecord): string;
var
  rst: OleVariant;
begin
  //Default
  Result := '';
  //Query our recordset
  try
      //Query

    { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    rst := con.Execute('SELECT ptScratchPad From Patients where ptDFN  = ' + IntToStr(Patient.DFN), EmptyParam, 0);
    rst := con.Execute('SELECT ptScratchPad From Patients where ptDFN  = ''' + IntToStr(Patient.DFN) + '''', EmptyParam, 0);
     //Have any?
    if not VarType(rst) = VarDispatch then
      Exit;
    if rst.EOF and rst.BOF then
      Exit;
  except
    on E: Exception do
    begin
      Exit;
    end;
  end;

  //Now return the result set
  Result := Nz(rst.Fields['ptScratchPad'], '');
end;

function DBClose(Compact: boolean): boolean;
var
  jet: OLEvariant;
begin
  //Close
  try
      //Close the database
    if VarType(con) = VarDispatch then
      con.Close;
    Result := True;
  except
      //Couldn't
    Result := False;
    Application.HandleException(nil);
  end;

  //Compact?
  if (Result = True) and (Compact = True) then
  begin
    try
          //Begin the compact
      jet := CreateOLEObject('JRO.JetEngine');
      if VarType(jet) = VarDispatch then
      begin
                //Change our status
        ShowStatus('Backing up database file ' + CurrDB);
                //Backup our database
        CopyFile(PChar(CurrDB), PChar(CurrDB + '.backup'), False);
                //Now compact
        ShowStatus('Compacting database file ' + CurrDB);
        jet.CompactDatabase('Provider=Microsoft.Jet.OLEDB.4.0;Data Source=' + CurrDB, 'Provider=Microsoft.Jet.OLEDB.4.0;Data Source=' + CurrDB + '.compact;Jet OLEDB:Engine type=5');
        DeleteFile(PChar(CurrDB));
        RenameFile(CurrDB + '.compact', CurrDB);
                //If we're here then everything went ok.  Delete the backup
        ShowStatus('Removing Backup database file ' + CurrDB + '.backup');
        DeleteFile(PChar(CurrDB + '.backup'));
      end;

          //Done
      Result := True;
            { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- could not use Handle}
//            MessageDlg('Database has been compacted successfully',mtInformation,[mbOK],0);
      MessageBox(0, PChar('Database has been compacted successfully'), 'Database Compacted', MB_ICONINFORMATION or MB_OK);
    except
          //Unable to do so
      Result := False;
      Application.HandleException(nil);
          //There was an error.. attempt to restore the backup
          { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian }
//            MessageDlg('There was an error compacting the Database.  MED will attempt to restore the Database Backup',mtError,[mbOK],0);
      MessageBox(0, PChar('There was an error compacting the Database.  MED will attempt to restore the Database Backup'),
        'Error Compacting Database', MB_ICONERROR or MB_OK);

      ShowStatus('Restoring Backup database file to ' + CurrDB);
      CopyFile(PChar(CurrDB + '.backup'), PChar(CurrDB), False);
    end;
  end;

end;

function WriteFile(fileName, contents: string): boolean;
var
  fileIO: Text;
begin
  //Default
  Result := False;
  { TODO -oHerb -cSQA : File operation needs to be in a try/finally block - per Brian }
  AssignFile(fileIO, fileName);
  try
    //Write the File
    try
      //Create/Overwrite?
      AssignFile(fileIO, fileName);
      Rewrite(fileIO); //Create the file
      //Write our contents
      Write(fileIO, contents);
      //Close the file
      Flush(fileIO);
//        CloseFile(fileIO);
    except
      on E: exception do
      begin
          //Error
          { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//        ShowMessage('WriteFile Error:' + E.Message);
        MessageBox(0, PChar('WriteFile Error:' + E.Message), 'Error', MB_OK);
        Application.HandleException(nil);
      end;
    end;
  finally
    CloseFile(fileIO);
  end;
end;

{ TODO -oHerb -cSQA :
Brian rewrote ReadFile because we could not get the original version
to work with the try/final block in place. }
{
function ReadFile(fileName:string):string;
var
  fileIO:Text;
  line,contents:string;
begin
  //Default
    Result := '';

  //Read the file
    try
      //Open?
        AssignFile(fileIO, fileName);
        Reset(fileIO);
      //Read our contents
      while Eof(fileIO) = False do
      begin
        //Output

        //Read
          Readln(fileIO, line);
        //Append
          contents := contents + line + CRLF;
      end;

      //Close the file
        CloseFile(fileIO);
    except
      on E:exception do
        begin
            //
        end;
    end;

  //Return our contents
    Result := contents;
end;
}

{ TODO -oHerb -cSQA :
Brian rewrote ReadFile because we could not get the original version
to work with the try/final block in place. }

function ReadFile(fileName: string): string;
var
  Info: TStringList;
begin
  Result := '';

  if not FileExists(FileName) then
    exit;

  Info := TStringList.Create;
  try
    Info.LoadFromFile(fileName);
    Result := Info.Text;
  finally
    FreeAndNil(Info);
  end;
end;


{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function DeleteHealthSummFile(ForPatIEN: Integer): boolean;
function DeleteHealthSummFile(ForPatIEN: INT64): boolean;
begin
  //Default
  Result := False;
  //Try to delete the file
  try
      //Delete the File
    Result := sysutils.DeleteFile(AppDataPath + '\db\' + IntToStr(ForPatIEN) + '.hsm');
  except
    on E: exception do
    begin
      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('Error while deleting ' + IntToStr(ForPatIEN) + '.hsm Health Summary file on this local machine');
      MessageBox(0, PChar('Error while deleting ' + IntToStr(ForPatIEN) + '.hsm Health Summary file on this local machine'), 'Error', MB_OK);
      Application.HandleException(nil);
      Exit;
    end;
  end;
end;

function DeleteHealthSummFiles(): boolean;
var
  sr: TSearchRec;
begin
  //Default
  Result := False;
  //Try to loop
  try
      //Loop through the directory searching for .hsm files
    if FindFirst(AppDataPath + '\db\*.hsm', faAnyFile, sr) = 0 then
    begin
            //Delete the File
      Result := sysutils.DeleteFile(AppDataPath + '\db\' + sr.Name);
            //Failed?
      if Result = False then
        Exit;
            //Now the remaining files
      while FindNext(sr) = 0 do
      begin
                  //Delete the File
        Result := sysutils.DeleteFile(AppDataPath + '\db\' + sr.Name);
                  //Failed?
        if Result = False then
          Exit;
      end;
    end;
  except
    on E: exception do
    begin
      { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('Error while deleting .hsm Health Summary files on this local machine');
      MessageBox(0, PChar('Error while deleting .hsm Health Summary files on this local machine'), 'Error', MB_OK);
      Application.HandleException(nil);
      Exit;
    end;
  end;
  //Successful
  Result := True;
end;

function SaveSettings(): boolean;
begin
  //Default
  Result := False;

  //TemplateUpdatePath
  if ExecuteQuery('Update Settings set stValue = ''' + SQLSafe(TemplateUpdatePath) + ''' where stName = ''TemplateUpdatePath''') = False then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
    //    ShowMessage('Error saving Template Update Path setting');
    MessageBox(0, PChar('Error saving Template Update Path setting'), 'Error', MB_OK);
    Exit;
  end;

  //SuggestCompact
  if ExecuteQuery('Update Settings set stValue = ''' + DBBool(SuggestCompact) + ''' where stName = ''SuggestCompact''') = False then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Error saving Suggest Compact setting');
    MessageBox(0, PChar('Error saving Suggest Compact setting'), 'Error', MB_OK);
    Exit;
  end;

  //CompactAtSize
  if ExecuteQuery('Update Settings set stValue = ''' + InttoStr(CompactAtSize) + ''' where stName = ''CompactAtSize''') = False then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Error saving Compact At Size setting');
    MessageBox(0, PChar('Error saving Compact At Size setting'), 'Error', MB_OK);
    Exit;
  end;

  //RetrieveHS
  if ExecuteQuery('Update Settings set stValue = ''' + DBBool(RetrieveHS) + ''' where stName = ''RetrieveHS''') = False then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Error saving Retrieve Health Summary setting');
    MessageBox(0, PChar('Error saving Retrieve Health Summary setting'), 'Error', MB_OK);
    Exit;
  end;

  //Save Interval
  if ExecuteQuery('Update Settings set stValue = ''' + InttoStr(SaveInterval) + ''' where stName = ''SaveInterval''') = False then
  begin
    { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//    ShowMessage('Error saving Compact At Size setting');
    MessageBox(0, PChar('Error saving Save Interval setting'), 'Error', MB_OK);
    Exit;
  end;


  //Done
  Result := True;
end;

procedure GetSettings();
var
  name, value: string;
  rst: OleVariant;
  NonExist :TStringList;
  I :Integer;
begin
  //Defaults
  TemplateUpdatePath := '';
  SuggestCompact := False;
  CompactAtSize := 0;
  RetrieveHS := True;
  SaveInterval := 5;
  NonExist := TStringList.Create;
  try
    NonExist.Add('templateupdatepath');
    NonExist.Add('suggestcompact');
    NonExist.Add('compactatsize');
    NonExist.Add('retrievehs');
    NonExist.Add('saveinterval');
    //Get our settings
    try
        //Get the Settings
      rst := con.Execute('SELECT stName,stValue FROM Settings', EmptyParam, 0);

        //Get each item
      while (rst.EOF = False) do
      begin
              //Get the values
        name := LowerCase(Nz(rst.Fields['stName'], ''));
        value := Nz(rst.Fields['stValue'], '');

              //What's the Name?
        if name = 'templateupdatepath' then
        begin
                  //Set the path
          TemplateUpdatePath := value;

          NonExist.Delete(NonExist.IndexOf(name));
        end
        else if name = 'suggestcompact' then
        begin
                  //Suggest?
          if LowerCase(value) = 'true' then
            SuggestCompact := True
          else
            SuggestCompact := False;

          NonExist.Delete(NonExist.IndexOf(name));
        end
        else if name = 'compactatsize' then
        begin
                  //Numeric?
          if IsNumeric(value) then
            CompactAtSize := StrToInt(value)
          else
            CompactAtSize := 0;

          NonExist.Delete(NonExist.IndexOf(name));
        end
        else if name = 'retrievehs' then
        begin
                  //Retrieve?
          if LowerCase(value) = 'true' then
            RetrieveHS := True
          else
            RetrieveHS := False;

          NonExist.Delete(NonExist.IndexOf(name));
        end
        else if name = 'saveinterval' then
        begin
          if IsNumeric(value) then
            SaveInterval := StrToInt(value);

          NonExist.Delete(NonExist.IndexOf(name));
        end;
         //Next record
        rst.MoveNext;
      end;

      for I := 0 to NonExist.Count - 1 do
        con.Execute('INSERT INTO Settings (stName, stValue) Values ('''+ NonExist[I]+ ''', '''')');

    except
      on E: exception do
      begin
          //Show an Error
       { TODO -oHerb -c508 :  Replace ShowMessage with MessageBox -  Matt Greener said JAWS could not read the text }
//      ShowMessage('Error retrieving settings:' + E.Message);
        MessageBox(0, PChar('Error retrieving settings:' + E.Message), 'Error', MB_OK);
        Exit;
      end;
    end;
  finally
    FreeAndNil(NonExist);
  end;
end;

function GetFileSizeMB(fileName: string): integer;
var
  { TODO -oHerb -cSQA : File operation needs to be in a try/finally block - per Brian }
  SerS : TSearchRec;
begin
  if FindFirst(fileName,faAnyFile,SerS) = 0 then
    Result := SerS.Size div 1048576
  else Result := -1;
  FindClose(SerS);

end;

//*******************************************************//
//  ZZZZZZBELLC                                          //
//                                                       //
// In the prior patch, the databse was converted back to //
// pre int64. This caused an issue with the imported DLL //
// since it was not updated. This also reintroduced a    //
// potential issue with large ints. This utility was     //
// written in order to maintain the database data and    //
// convert the database over to its proper datatypes.    //
// Once converted the original import dll will be fully  //
// functioning                                           //
//                                                       //
//*******************************************************//
Procedure TIU315DBFix;
const
 adInteger = 3;

 Function UpdateNeeded: Boolean;
 var
  rst: OleVariant;
 begin
   rst := con.execute('Select ntPatNbr from notes where 1=2');
   Result := rst.Fields['ntPatNbr'].Type = adInteger;
 end;

begin
 try
  if UpdateNeeded then
  begin
   //Drop the relationship
   con.execute('ALTER TABLE Notes DROP CONSTRAINT PatientsNotes');

   //Update the fields
   con.execute('ALTER TABLE Patients ALTER ptDFN Varchar(100)');
   con.execute('ALTER TABLE Patients ALTER ptDOB Varchar(100)');
   con.execute('ALTER TABLE Notes ALTER ntPatNbr Varchar(100)');

   //Add the relationship back
   con.execute('ALTER TABLE Notes ADD CONSTRAINT PatientsNotes FOREIGN KEY (ntPatNbr) REFERENCES Patients(ptDFN)');
  end;

 except
  On e: exception do
    raise exception.Create
    ('An Error has occured while update the Database for patch TIU*1.0*315' + #13#10 +
            SysErrorMessage(GetLastError) + #13#10 + 'Exception Class: ' +
            e.ClassName + #13#10 + 'Exception Message: ' + e.Message);
 end;
end;

end.
