unit uFindItems;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface
type
  TFindItem = class(TObject)
  public
    Line: integer;
    Pos: integer;
    constructor Create(Line: integer; Pos: integer);
  end;

  TFindItemArr = array of TFindItem;

  TFindItems = class(TObject)
  public
    destructor Destroy(); override;
    function CreateItem(Line: integer; Pos: integer): TFindItem;
  private
    arItems: TFindItemArr;
  end;

implementation

{TFindItem}

constructor TFindItem.Create(Line: integer; Pos: integer);
begin
  Self.Line := Line;
  Self.Pos := Pos;
end;

{TFindItems}

destructor TFindItems.Destroy();
var
  i: integer;
begin
    //Release our Items
  for i := Low(Self.arItems) to High(Self.arItems) do
  begin
    if assigned(Self.arItems[i]) then
      Self.arItems[i].Free;
  end;
    //Release our array reference explicity
  Self.arItems := nil;
    //Now let our inherited class do it's own thing
  inherited Destroy;
end;

function TFindItems.CreateItem(Line: integer; Pos: integer): TFindItem;
var
  itmNew: TFindItem;
  i: integer;
begin
    //Create it
  itmNew := TFindItem.Create(Line, Pos);
    //Now add it to our array
  if (not assigned(Self.arItems)) then
    i := 0
  else
    i := Length(Self.arItems);

  SetLength(Self.arItems, i + 1);
  Self.arItems[i] := itmNew;

    //Now return it
  Result := itmNew;
end;

end.
