unit uNote;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses SysUtils, uCore, uPatient, Forms,
     { TODO -oHerb -c508 conversion : Add Variants to uses clause for VarType }
  Variants;


type
  TNoteRecord = class(TObject)
  public
    Title: string;
    Caption: string;
    Text: string;
    Saved: boolean;
    Data: pointer;
    NoteID: integer;
    Imported: boolean;

    { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    ParentDFN: integer;
    ParentDFN: INT64;

    function SaveNote(): boolean;
    function SetNoteData(rcdPat: OleVariant): boolean;
    function DeleteNote(): boolean;
    constructor Create(Patient: TPatRecord);
  end;

  TNoteRecordArr = array of TNoteRecord;
implementation

uses uDB;

{TNote}

constructor TNoteRecord.Create(Patient: TPatRecord);
begin
  if assigned(Patient) then
    Self.ParentDFN := Patient.DFN
  else
    Self.ParentDFN := -1;
end;

function TNoteRecord.SaveNote(): boolean;
var
  strSave: string;
begin
    //Save or Update?
  if Self.NoteID <= 0 then
  begin
          //Insert

    { TODO -oherb -ccIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    strSave := 'INSERT INTO Notes(ntPatNbr,ntNoteTitle,ntCaption,ntNote) VALUES (' + IntToStr(Self.ParentDFN) + ',''' + SQLSafe(Self.Title) + ''',''' + SQLSafe(Self.Caption) + ''',''' + SQLSafe(Self.Text) + ''')';
    strSave := 'INSERT INTO Notes(ntPatNbr,ntNoteTitle,ntCaption,ntNote) VALUES (''' + IntToStr(Self.ParentDFN) + ''',''' + SQLSafe(Self.Title) + ''',''' + SQLSafe(Self.Caption) + ''',''' + SQLSafe(Self.Text) + ''')';
  end
  else
  begin
          //Update
    strSave := 'UPDATE Notes SET ntNoteTitle = ''' + SQLSafe(Self.Title) + ''', ntCaption = ''' + SQLSafe(Self.Caption) + ''', ntNote = ''' + SQLSafe(Self.Text) + ''' WHERE ntRfnbr = ' + IntToStr(Self.NoteID);
  end;

    //Now save it
  Result := ExecuteQuery(strSave);
    //Have an ID?
  if Result = True then
  begin
          //No. Let's get it.
    GetNoteID(Self);
  end;

end;

function TNoteRecord.DeleteNote(): boolean;
var
  strDel: string;
begin
    //Default
  Result := False;
    //Can we delete this from the db?
  if Self.NoteID <= 0 then Exit; //No.
    //Create our delete query
  strDel := 'DELETE from Notes WHERE ntRfnbr = ' + IntToStr(Self.NoteID);
    //Now delete it
  Result := ExecuteQuery(strDel);
end;

function TNoteRecord.SetNoteData(rcdPat: OleVariant): boolean;
var

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  ParentDFN, NoteID: integer;
  ParentDFN : INT64;
  NoteID : integer;
  Caption, Title, Note: string;
  Imported: boolean;
begin
    //Default
  Result := False;
    //Ensure we have a recordset object
  if not VarType(rcdPat) = VarDispatch then
    Exit;
    //Now set our patient
  try
        //Get our values
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//    ParentDFN := StrToInt(Nz(rcdPat.Fields['ntPatNbr'], '-1'));
    ParentDFN := StrToInt64(Nz(rcdPat.Fields['ntPatNbr'], '-1'));
    NoteID := StrToInt(Nz(rcdPat.Fields['ntRfnbr'], '-1'));
    Title := Nz(rcdPat.Fields['ntNoteTitle'], '');
    Caption := Nz(rcdPat.Fields['ntCaption'], '');
    Note := Nz(rcdPat.Fields['ntNote'], '');

     { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//    Imported := (Nz(rcdPat.Fields['ntImported'], '0') <> '0');
    Imported := (Nz(rcdPat.Fields['ntImported'], 'False') <> 'False');


        //Everything's ok
    Self.ParentDFN := ParentDFN;
    Self.NoteID := NoteID;
    Self.Title := Title;
    Self.Caption := Caption;
    Self.Text := Note;
    Self.Saved := True;
    Self.Imported := Imported;

    Result := True;
  except
    Application.HandleException(nil);
  end;
end;
end.
