unit uTemplateXML;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses sysutils, dialogs, classes, MSXML_TLB, XMLUtils;

function AddTemplateXML(xmlString: string): string;
//  procedure RemTemplateXML(name:string);
function GetTemplateXML(name: string): string;


const
  XMLTemplateTag = 'TEMPLATE';

var
  xmlTemplateNames: TStringList;
  xmlTemplates: TStringList;

implementation
//Return the specified template from our list

function GetTemplateXML(name: string): string;
var
  i: integer;
begin
    //Default value
  Result := '';

    //Find our template
  i := xmlTemplateNames.IndexOf(name);
  if i = -1 then
    Exit;

    //Return this item
  Result := xmlTemplates.Strings[i];
end;

//Add a template to our list

function AddTemplateXML(xmlString: string): string;
var
  xmlTemplate: IXMLDOMDocument;
  RootElement: IXMLDOMElement;
  FXMLElement: IXMLDOMNode;
  TmpName: string;
begin
    //Set our default value
  Result := '';

    //Open our template
  xmlTemplate := CoDOMDocument.Create;
    //Have one?
  if not assigned(xmlTemplate) then
  begin
          //Done
    Exit;
  end;
  xmlTemplate.preserveWhiteSpace := TRUE;
  xmlTemplate.loadXML(xmlString);

    //Any errors?
  if xmlTemplate.Get_parseError.Get_errorCode <> 0 then
  begin
          //Error
    Exit;
  end;

    //Create our template
  RootElement := xmlTemplate.Get_documentElement;
  FXMLElement := FindXMLElement(RootElement, XMLTemplateTag);
    //Get the name attribute
  TmpName := FindXMLAttributeValue(FXMLElement, 'NAME');
    //Have one?
  if TmpName = '' then
  begin
    Exit;
  end;

    //Add it
  xmlTemplateNames.Add(TmpName);
  xmlTemplates.Add(xmlString);

    //Now return it
  Result := TmpName;
end;


initialization
  //Create our strings
  xmlTemplateNames := TStringList.Create;
  xmlTemplates := TStringList.Create;
finalization
  //Release them
  if assigned(xmlTemplateNames) then
    xmlTemplateNames.Free;
  if assigned(xmlTemplates) then
    xmlTemplates.Free;
end.
