unit uUtils;

interface

uses
 windows, sysutils, orfn;

function FileVersionValue(const AFileName, AValueName: string): string;
function ClientVersion(const AFileName: string): string;
function CompareVersion(const A, B: string): Integer;

implementation

function CompareVersion(const A, B: string): Integer;
var
  NumA, NumB: Integer;
begin
  NumA := (StrToInt(Piece(A, '.', 1)) * 16777216) +
          (StrToInt(Piece(A, '.', 2)) * 65536) +
          (StrToInt(Piece(A, '.', 3)) * 256) +
           StrToInt(Piece(A, '.', 4));
  NumB := (StrToInt(Piece(B, '.', 1)) * 16777216) +
          (StrToInt(Piece(B, '.', 2)) * 65536) +
          (StrToInt(Piece(B, '.', 3)) * 256) +
           StrToInt(Piece(B, '.', 4));
  Result := NumA - NumB;
end;

function ClientVersion(const AFileName: string): string;
var
  ASize, AHandle: DWORD;
  Buf: string;
  FileInfoPtr: Pointer; //PVSFixedFileInfo;
begin
  Result := '';
  ASize:=GetFileVersionInfoSize(PChar(AFileName), AHandle);
  if ASize > 0 then
  begin
    SetLength(Buf, ASize);
    GetFileVersionInfo(PChar(AFileName), AHandle, ASize, Pointer(Buf));
    VerQueryValue(Pointer(Buf), '\', FileInfoPtr, ASize);
    with TVSFixedFileInfo(FileInfoPtr^) do Result := IntToStr(HIWORD(dwFileVersionMS)) + '.' +
                                                     IntToStr(LOWORD(dwFileVersionMS)) + '.' +
                                                     IntToStr(HIWORD(dwFileVersionLS)) + '.' +
                                                     IntToStr(LOWORD(dwFileVersionLS));
  end;
end;

function FileVersionValue(const AFileName, AValueName: string): string;
type
  TValBuf = array[0..255] of Char;
  PValBuf = ^TValBuf;
const
 FILE_VER_PREFIX = '\StringFileInfo\';
var
  VerSize, ValSize, AHandle: DWORD;
  VerBuf: Pointer;
  ValBuf: PValBuf;
  Output, Query: string;
  POutput: PChar;
begin
  Result := '';
  VerSize:=GetFileVersionInfoSize(PChar(AFileName), AHandle);
  if VerSize > 0 then
  begin
    GetMem(VerBuf, VerSize);
    try
      GetFileVersionInfo(PChar(AFileName), AHandle, VerSize, VerBuf);
      VerQueryValue(VerBuf, PChar('\VarFileInfo\Translation'), Pointer(ValBuf), ValSize);
      Query := FILE_VER_PREFIX + IntToHex(LoWord(PLongInt(ValBuf)^),4)+
                               IntToHex(HiWord(PLongInt(ValBuf)^),4)+
                               '\'+AValueName;
      VerQueryValue(VerBuf, PChar(Query), Pointer(ValBuf), ValSize);
      SetString(Output, ValBuf^, ValSize);
      POutput := PChar(Output);
      Result := POutput;
    finally
      FreeMem(VerBuf);
    end;
  end;
end;

end.
